/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.filter;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class TagMeasurementFilter
implements Predicate<Measurement> {
    private final Pattern meterNamePattern;
    private final Pattern tagNamePattern;
    private final Pattern tagValuePattern;

    private static Pattern regexToPatternOrNull(String regex) {
        if (regex != null && !regex.isEmpty() && !regex.equals(".*")) {
            return Pattern.compile(regex);
        }
        return null;
    }

    private static boolean stringMatches(String text, Pattern pattern) {
        return pattern == null || pattern.matcher(text).matches();
    }

    public TagMeasurementFilter(String meterNameRegex, String tagNameRegex, String tagValueRegex) {
        this.meterNamePattern = TagMeasurementFilter.regexToPatternOrNull(meterNameRegex);
        this.tagNamePattern = TagMeasurementFilter.regexToPatternOrNull(tagNameRegex);
        this.tagValuePattern = TagMeasurementFilter.regexToPatternOrNull(tagValueRegex);
    }

    @Override
    public boolean test(Measurement measurement) {
        Id id = measurement.id();
        if (!TagMeasurementFilter.stringMatches(id.name(), this.meterNamePattern)) {
            return false;
        }
        if (this.tagNamePattern != null || this.tagValuePattern != null) {
            for (Tag tag : id.tags()) {
                boolean nameOk = TagMeasurementFilter.stringMatches(tag.key(), this.tagNamePattern);
                boolean valueOk = TagMeasurementFilter.stringMatches(tag.value(), this.tagValuePattern);
                if (!nameOk || !valueOk) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

