/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffByteArray;
import com.netflix.zeno.diff.DiffRecord;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DiffFrameworkSerializer
extends FrameworkSerializer<DiffRecord> {
    private static final Object NULL_OBJECT = new Integer(-2147483548);

    public DiffFrameworkSerializer(SerializationFramework framework) {
        super(framework);
    }

    @Override
    public void serializePrimitive(DiffRecord rec, String fieldName, Object value) {
        rec.serializePrimitive(fieldName, value);
    }

    @Override
    public void serializeBytes(DiffRecord rec, String fieldName, byte[] value) {
        rec.serializePrimitive(fieldName, new DiffByteArray(value));
    }

    @Override
    public void serializeObject(DiffRecord rec, String fieldName, String typeName, Object obj) {
        if (obj == null) {
            this.serializePrimitive(rec, fieldName, NULL_OBJECT);
            return;
        }
        rec.serializeObject(fieldName);
        this.getSerializer(typeName).serialize(obj, rec);
        rec.finishedObject();
    }

    @Override
    public void serializeObject(DiffRecord rec, String fieldName, Object obj) {
        this.serializeObject(rec, fieldName, rec.getSchema().getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(DiffRecord rec, String fieldName, String typeName, Collection<T> obj) {
        this.serializeCollection(rec, fieldName, typeName, obj);
    }

    @Override
    public <T> void serializeSet(DiffRecord rec, String fieldName, String typeName, Set<T> obj) {
        this.serializeCollection(rec, fieldName, typeName, obj);
    }

    private <T> void serializeCollection(DiffRecord rec, String fieldName, String typeName, Collection<T> obj) {
        if (obj == null) {
            this.serializePrimitive(rec, fieldName, NULL_OBJECT);
            return;
        }
        rec.serializeObject(fieldName);
        for (T t : obj) {
            this.serializeObject(rec, "element", typeName, t);
        }
        rec.finishedObject();
    }

    @Override
    public <K, V> void serializeMap(DiffRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> obj) {
        if (obj == null) {
            this.serializePrimitive(rec, fieldName, NULL_OBJECT);
            return;
        }
        rec.serializeObject(fieldName);
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            this.serializeObject(rec, "key", keyTypeName, entry.getKey());
            this.serializeObject(rec, "value", valueTypeName, entry.getValue());
        }
        rec.finishedObject();
    }
}

