/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffHeader;
import com.netflix.zeno.diff.DiffInstruction;
import com.netflix.zeno.diff.DiffReport;
import com.netflix.zeno.diff.DiffReportGenerationException;
import com.netflix.zeno.diff.DiffSerializationFramework;
import com.netflix.zeno.diff.TypeDiff;
import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.diff.TypeDiffOperation;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.serializer.SerializerFactory;
import java.util.ArrayList;

public class DiffOperation {
    private final SerializerFactory serializerFactory;
    private final DiffInstruction instruction;

    public DiffOperation(SerializerFactory dataModel, DiffInstruction instruction) {
        this.serializerFactory = dataModel;
        this.instruction = instruction;
    }

    public DiffReport performDiff(FastBlobStateEngine fromState, FastBlobStateEngine toState) throws DiffReportGenerationException {
        return this.performDiff(null, fromState, toState);
    }

    public DiffReport performDiff(DiffHeader diffHeader, FastBlobStateEngine fromState, FastBlobStateEngine toState) throws DiffReportGenerationException {
        try {
            ArrayList diffs = new ArrayList();
            DiffSerializationFramework framework = new DiffSerializationFramework(this.serializerFactory);
            for (TypeDiffInstruction<?> instruction : this.instruction.getTypeInstructions()) {
                if (!instruction.isUniqueKey()) continue;
                FastBlobTypeDeserializationState fromDeserializationState = fromState.getTypeDeserializationState(instruction.getSerializerName());
                FastBlobTypeDeserializationState toDeserializationState = toState.getTypeDeserializationState(instruction.getSerializerName());
                TypeDiff typeDiff = this.performDiff(framework, instruction, fromDeserializationState, toDeserializationState);
                diffs.add(typeDiff);
            }
            return new DiffReport(diffHeader, diffs);
        }
        catch (Exception e) {
            throw new DiffReportGenerationException(e);
        }
    }

    private <T> TypeDiff<T> performDiff(DiffSerializationFramework framework, TypeDiffInstruction<?> diff, Iterable<?> from, Iterable<?> to) {
        TypeDiffInstruction<?> castDiff = diff;
        Iterable<?> castFrom = from;
        Iterable<?> castTo = to;
        return new TypeDiffOperation(castDiff).performDiff(framework, castFrom, castTo, Runtime.getRuntime().availableProcessors());
    }
}

