/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class DiffPropertyPath
implements Cloneable,
Comparable<DiffPropertyPath> {
    private static final ConcurrentHashMap<DiffPropertyPath, DiffPropertyPath> canonicalDiffBreadcrumbs = new ConcurrentHashMap();
    private String topNodeSerializer;
    private final String[] fieldBreadcrumbs;
    private int breadcrumbLength;
    private int hashCode;

    public DiffPropertyPath() {
        this.fieldBreadcrumbs = new String[256];
        this.breadcrumbLength = 0;
    }

    private DiffPropertyPath(DiffPropertyPath copy) {
        this.topNodeSerializer = copy.topNodeSerializer;
        this.fieldBreadcrumbs = copy.getFieldBreadcrumbsCopy();
        this.breadcrumbLength = this.fieldBreadcrumbs.length;
        this.hashCode = copy.hashCode;
    }

    DiffPropertyPath(String topNodeSerializer, String[] fieldBreadcrumbs) {
        this.topNodeSerializer = topNodeSerializer;
        this.fieldBreadcrumbs = fieldBreadcrumbs;
        this.breadcrumbLength = fieldBreadcrumbs.length;
    }

    String getTopNodeSerializer() {
        return this.topNodeSerializer;
    }

    String[] getBreadcrumbArray() {
        return this.fieldBreadcrumbs;
    }

    int getBreadcrumbLength() {
        return this.breadcrumbLength;
    }

    public void setTopNodeSerializer(String topNodeSerializer) {
        this.hashCode = 0;
        this.topNodeSerializer = topNodeSerializer;
    }

    public void addBreadcrumb(String field) {
        if (this.hashCode != 0) {
            this.hashCode ^= this.breadcrumbLength * field.hashCode();
        }
        this.fieldBreadcrumbs[this.breadcrumbLength] = field;
        ++this.breadcrumbLength;
    }

    public void removeBreadcrumb() {
        --this.breadcrumbLength;
        if (this.hashCode != 0) {
            this.hashCode ^= this.breadcrumbLength * this.fieldBreadcrumbs[this.breadcrumbLength].hashCode();
        }
    }

    public void reset() {
        this.hashCode = 0;
        this.breadcrumbLength = 0;
    }

    public DiffPropertyPath copy() {
        DiffPropertyPath newCopy;
        DiffPropertyPath copy = canonicalDiffBreadcrumbs.get(this);
        if (copy == null && (copy = canonicalDiffBreadcrumbs.putIfAbsent(newCopy = new DiffPropertyPath(this), newCopy)) == null) {
            copy = newCopy;
        }
        return copy;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject instanceof DiffPropertyPath) {
            DiffPropertyPath other = (DiffPropertyPath)anotherObject;
            if (other.breadcrumbLength == this.breadcrumbLength && other.topNodeSerializer.equals(this.topNodeSerializer)) {
                for (int i = this.breadcrumbLength - 1; i >= 0; --i) {
                    if (other.fieldBreadcrumbs[i].equals(this.fieldBreadcrumbs[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 1 + 32 * this.topNodeSerializer.hashCode();
        for (int i = 0; i < this.breadcrumbLength; ++i) {
            result ^= i * this.fieldBreadcrumbs[i].hashCode();
        }
        this.hashCode = result;
        return result;
    }

    @Override
    public int compareTo(DiffPropertyPath o) {
        int comp = this.topNodeSerializer.compareTo(o.topNodeSerializer);
        if (comp == 0) {
            comp = this.breadcrumbLength - o.breadcrumbLength;
            for (int i = this.breadcrumbLength - 1; i >= 0 && comp == 0; --i) {
                comp = this.fieldBreadcrumbs[i].compareTo(o.fieldBreadcrumbs[i]);
            }
        }
        return comp;
    }

    private String[] getFieldBreadcrumbsCopy() {
        return Arrays.copyOf(this.fieldBreadcrumbs, this.breadcrumbLength);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.topNodeSerializer);
        for (int i = 0; i < this.breadcrumbLength; ++i) {
            builder.append(".");
            builder.append(this.fieldBreadcrumbs[i]);
        }
        return builder.toString();
    }
}

