/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffPropertyPath;
import com.netflix.zeno.diff.DiffRecordValueListMap;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFSerializationRecord;

public class DiffRecord
extends NFSerializationRecord {
    private final DiffPropertyPath propertyPath = new DiffPropertyPath();
    private final DiffRecordValueListMap fieldValues = new DiffRecordValueListMap();
    private FastBlobSchema schema;

    @Override
    public void setSchema(FastBlobSchema schema) {
        this.schema = schema;
    }

    @Override
    public FastBlobSchema getSchema() {
        return this.schema;
    }

    public void setTopLevelSerializerName(String topNodeSerializer) {
        this.propertyPath.setTopNodeSerializer(topNodeSerializer);
    }

    public void serializeObject(String fieldName) {
        this.propertyPath.addBreadcrumb(fieldName);
    }

    public void finishedObject() {
        this.propertyPath.removeBreadcrumb();
    }

    public void serializePrimitive(String fieldName, Object value) {
        this.propertyPath.addBreadcrumb(fieldName);
        this.fieldValues.addValue(this.propertyPath, value);
        this.propertyPath.removeBreadcrumb();
    }

    public void clear() {
        this.propertyPath.reset();
        this.fieldValues.clear();
    }

    public DiffRecordValueListMap getValueListMap() {
        return this.fieldValues;
    }

    DiffRecordValueListMap getFieldValues() {
        return this.fieldValues;
    }
}

