/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffPropertyPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiffRecordValueListMap {
    private final Map<DiffPropertyPath, Integer> fieldValuesLists = new HashMap<DiffPropertyPath, Integer>();
    private final List<List<Object>> valuesLists = new ArrayList<List<Object>>();
    private int nextValueIndex;

    public void addValue(DiffPropertyPath path, Object obj) {
        this.getOrCreateList(path).add(obj);
    }

    public List<Object> getList(DiffPropertyPath path) {
        Integer listIndex = this.fieldValuesLists.get(path);
        if (listIndex == null) {
            return null;
        }
        return this.getList(listIndex);
    }

    private List<Object> getOrCreateList(DiffPropertyPath path) {
        Integer listIndex = this.fieldValuesLists.get(path);
        if (listIndex == null) {
            listIndex = this.nextValueIndex++;
            this.fieldValuesLists.put(path.copy(), listIndex);
        }
        return this.getList(listIndex);
    }

    private List<Object> getList(int listIndex) {
        while (this.valuesLists.size() <= listIndex) {
            this.valuesLists.add(new ArrayList());
        }
        return this.valuesLists.get(listIndex);
    }

    public void clear() {
        for (List<Object> list : this.valuesLists) {
            list.clear();
        }
        this.fieldValuesLists.clear();
        this.nextValueIndex = 0;
    }

    public Iterable<DiffPropertyPath> keySet() {
        return this.fieldValuesLists.keySet();
    }
}

