/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffHeader;
import com.netflix.zeno.diff.TypeDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffReport {
    private final DiffHeader header;
    private final List<TypeDiff<?>> typeDiffs;
    private int totalDiffs;
    private int totalExtra;

    public DiffReport(DiffHeader header, List<TypeDiff<?>> typeDiffs) {
        this.header = header;
        this.typeDiffs = typeDiffs;
        for (TypeDiff<?> td : typeDiffs) {
            for (TypeDiff.ObjectDiffScore<?> objectDiffScore : td.getDiffObjects()) {
                this.totalDiffs += objectDiffScore.getScore();
            }
            this.totalExtra += td.getExtraInFrom().size() + td.getExtraInTo().size();
        }
    }

    public <T> TypeDiff<T> getTypeDiff(String topLevelSerializer) {
        for (TypeDiff<?> typeDiff : this.typeDiffs) {
            if (!typeDiff.getTopNodeSerializer().equals(topLevelSerializer)) continue;
            return typeDiff;
        }
        return null;
    }

    public List<TypeDiff<?>> getTypeDiffsSortedByDiffScore() {
        ArrayList typeDiffs = new ArrayList(this.typeDiffs.size());
        typeDiffs.addAll(this.typeDiffs);
        Collections.sort(typeDiffs, new Comparator<TypeDiff<?>>(){

            @Override
            public int compare(TypeDiff<?> o1, TypeDiff<?> o2) {
                return o2.getTotalDiffs() - o1.getTotalDiffs();
            }
        });
        return typeDiffs;
    }

    public List<TypeDiff<?>> getTypeDiffsSortedByExtraObjects() {
        ArrayList typeDiffs = new ArrayList(this.typeDiffs.size());
        typeDiffs.addAll(this.typeDiffs);
        Collections.sort(typeDiffs, new Comparator<TypeDiff<?>>(){

            @Override
            public int compare(TypeDiff<?> o1, TypeDiff<?> o2) {
                int extra2 = o2.getExtraInFrom().size() + o2.getExtraInTo().size();
                int extra1 = o1.getExtraInFrom().size() + o1.getExtraInTo().size();
                return extra2 - extra1;
            }
        });
        return typeDiffs;
    }

    public List<TypeDiff<?>> getTypeDiffsSortedByMissingFromObjects() {
        ArrayList typeDiffs = new ArrayList(this.typeDiffs.size());
        typeDiffs.addAll(this.typeDiffs);
        Collections.sort(typeDiffs, new Comparator<TypeDiff<?>>(){

            @Override
            public int compare(TypeDiff<?> o1, TypeDiff<?> o2) {
                int extra2 = o2.getExtraInFrom().size();
                int extra1 = o1.getExtraInFrom().size();
                return extra2 - extra1;
            }
        });
        return typeDiffs;
    }

    public List<TypeDiff<?>> getTypeDiffsSortedByMissingToObjects() {
        ArrayList typeDiffs = new ArrayList(this.typeDiffs.size());
        typeDiffs.addAll(this.typeDiffs);
        Collections.sort(typeDiffs, new Comparator<TypeDiff<?>>(){

            @Override
            public int compare(TypeDiff<?> o1, TypeDiff<?> o2) {
                int extra2 = o2.getExtraInTo().size();
                int extra1 = o1.getExtraInTo().size();
                return extra2 - extra1;
            }
        });
        return typeDiffs;
    }

    public int getTotalDiffs() {
        return this.totalDiffs;
    }

    public int getTotalExtra() {
        return this.totalExtra;
    }

    public DiffHeader getHeader() {
        return this.header;
    }
}

