/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffPropertyPath;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeDiff<T> {
    private final String topNodeSerializer;
    private final Map<DiffPropertyPath, FieldDiffScore<T>> fieldDifferences;
    private final List<T> extraInFrom;
    private final List<T> extraInTo;
    private final List<ObjectDiffScore<T>> objectDiffs;
    private int itemCountFrom;
    private int itemCountTo;

    public TypeDiff(String topNodeSerializer) {
        this.fieldDifferences = new HashMap<DiffPropertyPath, FieldDiffScore<T>>();
        this.extraInFrom = new ArrayList<T>();
        this.extraInTo = new ArrayList<T>();
        this.objectDiffs = new ArrayList<ObjectDiffScore<T>>();
        this.topNodeSerializer = topNodeSerializer;
    }

    TypeDiff(String topNodeSerializer, List<T> missingFrom, List<T> missingTo, List<ObjectDiffScore<T>> objectDiffs, Map<DiffPropertyPath, FieldDiffScore<T>> fieldDifferences, int itemCountFrom, int itemCountTo) {
        this.topNodeSerializer = topNodeSerializer;
        this.extraInFrom = missingFrom;
        this.extraInTo = missingTo;
        this.objectDiffs = objectDiffs;
        this.fieldDifferences = fieldDifferences;
        this.itemCountFrom = itemCountFrom;
        this.itemCountTo = itemCountTo;
    }

    public void addFieldObjectDiffScore(DiffPropertyPath fieldBreadcrumbs, T to, T from, int diffScore) {
        if (diffScore > 0) {
            ObjectDiffScore<T> fieldDiffScore = new ObjectDiffScore<T>(from, to, diffScore);
            FieldDiffScore<T> fieldDiff = this.getFieldDiffScore(fieldBreadcrumbs);
            fieldDiff.addObjectDiffScore(fieldDiffScore);
        }
    }

    public void incrementFieldScores(DiffPropertyPath fieldBreadcrumbs, int diffIncrement, int totalIncrement) {
        if (diffIncrement != 0 || totalIncrement != 0) {
            FieldDiffScore<T> fieldDiff = this.getFieldDiffScore(fieldBreadcrumbs);
            fieldDiff.incrementDiffCountBy(diffIncrement);
            fieldDiff.incrementTotalCountBy(totalIncrement);
        }
    }

    public void incrementFieldDiff(DiffPropertyPath fieldBreadcrumbs, int increment) {
        if (increment != 0) {
            FieldDiffScore<T> fieldDiff = this.getFieldDiffScore(fieldBreadcrumbs);
            fieldDiff.incrementDiffCountBy(increment);
        }
    }

    public void incrementFieldTotal(DiffPropertyPath fieldBreadcrumbs, int increment) {
        if (increment != 0) {
            FieldDiffScore<T> fieldDiff = this.getFieldDiffScore(fieldBreadcrumbs);
            fieldDiff.incrementTotalCountBy(increment);
        }
    }

    private FieldDiffScore<T> getFieldDiffScore(DiffPropertyPath fieldBreadcrumbs) {
        FieldDiffScore<T> counter = this.fieldDifferences.get(fieldBreadcrumbs);
        if (counter == null) {
            counter = new FieldDiffScore();
            this.fieldDifferences.put(fieldBreadcrumbs, counter);
        }
        return counter;
    }

    public void addExtraInFrom(T missing) {
        this.extraInFrom.add(missing);
    }

    public void addExtraInTo(T missing) {
        this.extraInTo.add(missing);
    }

    public void addDiffObject(T from, T to, int score) {
        this.objectDiffs.add(new ObjectDiffScore<T>(from, to, score));
    }

    public void incrementFrom() {
        ++this.itemCountFrom;
    }

    public void incrementFrom(int byCount) {
        this.itemCountFrom += byCount;
    }

    public void incrementTo() {
        ++this.itemCountTo;
    }

    public void incrementTo(int byCount) {
        this.itemCountTo += byCount;
    }

    public String getTopNodeSerializer() {
        return this.topNodeSerializer;
    }

    public List<T> getExtraInFrom() {
        return this.extraInFrom;
    }

    public List<T> getExtraInTo() {
        return this.extraInTo;
    }

    public int getItemCountFrom() {
        return this.itemCountFrom;
    }

    public int getItemCountTo() {
        return this.itemCountTo;
    }

    public int getTotalDiffs() {
        int totalDiffs = 0;
        for (ObjectDiffScore<T> objectDiffScore : this.objectDiffs) {
            totalDiffs += objectDiffScore.getScore();
        }
        return totalDiffs;
    }

    public List<FieldDiff<T>> getSortedFieldDifferencesDescending() {
        ArrayList<FieldDiff<T>> fieldDiffs = new ArrayList<FieldDiff<T>>(this.fieldDifferences.size());
        for (DiffPropertyPath key : this.fieldDifferences.keySet()) {
            fieldDiffs.add(new FieldDiff<T>(key, this.fieldDifferences.get(key)));
        }
        Collections.sort(fieldDiffs);
        return fieldDiffs;
    }

    public Map<DiffPropertyPath, FieldDiffScore<T>> getFieldDifferences() {
        return this.fieldDifferences;
    }

    public List<ObjectDiffScore<T>> getDiffObjects() {
        return this.objectDiffs;
    }

    public List<ObjectDiffScore<T>> getSortedDiffObjects() {
        ArrayList<ObjectDiffScore<T>> sortedList = new ArrayList<ObjectDiffScore<T>>(this.objectDiffs.size());
        sortedList.addAll(this.objectDiffs);
        Collections.sort(sortedList);
        return sortedList;
    }

    public List<ObjectDiffScore<T>> getSortedDiffObjectsByFields(List<DiffPropertyPath> includeFields) {
        HashMap<ObjectDiffScore<T>, ObjectDiffScore<T>> aggregatedScores = new HashMap<ObjectDiffScore<T>, ObjectDiffScore<T>>();
        for (DiffPropertyPath field : includeFields) {
            FieldDiffScore<T> fieldDiffScore = this.fieldDifferences.get(field);
            if (fieldDiffScore == null) continue;
            for (ObjectDiffScore<T> fieldObjectDiff : fieldDiffScore.getDiffScores()) {
                ObjectDiffScore<T> objectDiffCopy = (ObjectDiffScore<T>)aggregatedScores.get(fieldObjectDiff);
                if (objectDiffCopy == null) {
                    objectDiffCopy = new ObjectDiffScore<T>(fieldObjectDiff.getFrom(), fieldObjectDiff.getTo(), 0);
                    aggregatedScores.put(objectDiffCopy, objectDiffCopy);
                }
                ((ObjectDiffScore)objectDiffCopy).incrementScoreBy(fieldObjectDiff.getScore());
            }
        }
        ArrayList<ObjectDiffScore<T>> scores = new ArrayList<ObjectDiffScore<T>>(aggregatedScores.keySet());
        Collections.sort(scores);
        return scores;
    }

    public static class ObjectDiffScore<T>
    implements Comparable<ObjectDiffScore<T>> {
        private final T fromObject;
        private final T toObject;
        private int score;

        public ObjectDiffScore(T fromObject, T toObject, int score) {
            this.fromObject = fromObject;
            this.toObject = toObject;
            this.score = score;
        }

        public T getFrom() {
            return this.fromObject;
        }

        public T getTo() {
            return this.toObject;
        }

        public int getScore() {
            return this.score;
        }

        private void incrementScoreBy(int increment) {
            this.score += increment;
        }

        @Override
        public int compareTo(ObjectDiffScore<T> o) {
            return o.score - this.score;
        }

        public int hashCode() {
            return this.fromObject.hashCode() + 31 * this.toObject.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ObjectDiffScore) {
                ObjectDiffScore otherScore = (ObjectDiffScore)other;
                return otherScore.getFrom().equals(this.fromObject) && otherScore.getTo().equals(this.toObject);
            }
            return false;
        }
    }

    public static class FieldDiffScore<T>
    implements Comparable<FieldDiffScore<T>> {
        private int diffCount;
        private int totalCount;
        private final List<ObjectDiffScore<T>> objectScores = new ArrayList<ObjectDiffScore<T>>();

        public void incrementDiffCountBy(int count) {
            this.diffCount += count;
        }

        public void incrementTotalCountBy(int count) {
            this.totalCount += count;
        }

        public int getDiffCount() {
            return this.diffCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public List<ObjectDiffScore<T>> getDiffScores() {
            return this.objectScores;
        }

        public double getDiffPercent() {
            return (double)this.diffCount / (double)this.totalCount;
        }

        public void addObjectDiffScore(ObjectDiffScore<T> score) {
            this.objectScores.add(score);
        }

        @Override
        public int compareTo(FieldDiffScore<T> o) {
            double otherDiffPercent;
            double thisDiffPercent = this.getDiffPercent();
            if (thisDiffPercent == (otherDiffPercent = o.getDiffPercent())) {
                return 0;
            }
            return thisDiffPercent > otherDiffPercent ? -1 : 1;
        }

        public String toString() {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            return nf.format(this.getDiffPercent() * 100.0) + "% (" + this.diffCount + "/" + this.totalCount + ")";
        }
    }

    public static class FieldDiff<T>
    implements Comparable<FieldDiff<T>> {
        private final DiffPropertyPath propertyPath;
        private final FieldDiffScore<T> diffScore;

        public FieldDiff(DiffPropertyPath propertyPath, FieldDiffScore<T> diffScore) {
            this.propertyPath = propertyPath;
            this.diffScore = diffScore;
        }

        public DiffPropertyPath getPropertyPath() {
            return this.propertyPath;
        }

        @Deprecated
        public DiffPropertyPath getBreadcrumbs() {
            return this.propertyPath;
        }

        public FieldDiffScore<T> getDiffScore() {
            return this.diffScore;
        }

        @Override
        public int compareTo(FieldDiff<T> o) {
            return this.diffScore.compareTo(o.diffScore);
        }

        public String toString() {
            return this.propertyPath.toString() + ": " + this.diffScore.toString();
        }
    }
}

