/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff;

import com.netflix.zeno.diff.DiffPropertyPath;
import com.netflix.zeno.diff.DiffRecord;
import com.netflix.zeno.diff.DiffSerializationFramework;
import com.netflix.zeno.diff.TypeDiff;
import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.mutable.MutableInt;

public class TypeDiffOperation<T> {
    private final TypeDiffInstruction<T> instruction;
    private static final ThreadLocal<Map<Object, MutableInt>> objectSet = new ThreadLocal();

    public TypeDiffOperation(TypeDiffInstruction<T> instruction) {
        this.instruction = instruction;
    }

    public TypeDiff<T> performDiff(DiffSerializationFramework framework, Iterable<T> fromState, Iterable<T> toState) {
        return this.performDiff(framework, fromState, toState, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDiff<T> performDiff(DiffSerializationFramework framework, Iterable<T> fromState, Iterable<T> toState, int numThreads) {
        HashMap<Object, T> fromStateObjects = new HashMap<Object, T>();
        for (T obj : fromState) {
            fromStateObjects.put(this.instruction.getKey(obj), obj);
        }
        ArrayList perProcessorWorkList = new ArrayList(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            perProcessorWorkList.add(new ArrayList());
        }
        ConcurrentHashMap<Object, Object> toStateKeys = new ConcurrentHashMap<Object, Object>();
        int toIncrCount = 0;
        for (T toObject : toState) {
            ((List)perProcessorWorkList.get(toIncrCount % numThreads)).add(toObject);
            ++toIncrCount;
        }
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "TypeDiff_" + TypeDiffOperation.this.instruction.getTypeIdentifier());
                thread.setDaemon(true);
                return thread;
            }
        });
        try {
            ArrayList<Future<T>> workResultList = new ArrayList<Future<T>>(perProcessorWorkList.size());
            for (List typeDiff : perProcessorWorkList) {
                if (typeDiff == null || typeDiff.isEmpty()) continue;
                workResultList.add(executor.submit(new TypeDiffCallable<T>(framework, this.instruction, fromStateObjects, toStateKeys, typeDiff)));
            }
            TypeDiff mergedDiff = new TypeDiff(this.instruction.getTypeIdentifier());
            for (Future future : workResultList) {
                try {
                    TypeDiff typeDiff = (TypeDiff)future.get();
                    this.mergeTypeDiff(mergedDiff, typeDiff);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (Map.Entry entry : fromStateObjects.entrySet()) {
                mergedDiff.incrementFrom();
                if (toStateKeys.containsKey(entry.getKey())) continue;
                mergedDiff.addExtraInFrom(entry.getValue());
            }
            TypeDiff typeDiff = mergedDiff;
            return typeDiff;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void mergeTypeDiff(TypeDiff<T> mergedDiff, TypeDiff<T> typeDiff) {
        mergedDiff.getExtraInFrom().addAll(typeDiff.getExtraInFrom());
        mergedDiff.getExtraInTo().addAll(typeDiff.getExtraInTo());
        mergedDiff.getDiffObjects().addAll(typeDiff.getDiffObjects());
        mergedDiff.incrementFrom(typeDiff.getItemCountFrom());
        mergedDiff.incrementTo(typeDiff.getItemCountTo());
        Map<DiffPropertyPath, TypeDiff.FieldDiffScore<T>> mergedFieldDifferences = mergedDiff.getFieldDifferences();
        Map<DiffPropertyPath, TypeDiff.FieldDiffScore<T>> fieldDifferences = typeDiff.getFieldDifferences();
        for (DiffPropertyPath path : fieldDifferences.keySet()) {
            TypeDiff.FieldDiffScore<T> fieldDiffScore = fieldDifferences.get(path);
            TypeDiff.FieldDiffScore<T> mergedFieldDiffScore = mergedFieldDifferences.get(path);
            if (mergedFieldDiffScore != null) {
                mergedFieldDiffScore.incrementDiffCountBy(fieldDiffScore.getDiffCount());
                mergedFieldDiffScore.incrementTotalCountBy(fieldDiffScore.getTotalCount());
                mergedFieldDiffScore.getDiffScores().addAll(fieldDiffScore.getDiffScores());
                continue;
            }
            mergedFieldDifferences.put(path, fieldDiffScore);
        }
    }

    private Map<Object, MutableInt> getObjectMap() {
        Map<Object, MutableInt> objectSet = TypeDiffOperation.objectSet.get();
        if (objectSet == null) {
            objectSet = new HashMap<Object, MutableInt>();
            TypeDiffOperation.objectSet.set(objectSet);
        }
        return objectSet;
    }

    class TypeDiffCallable<Z>
    implements Callable<TypeDiff<Z>> {
        private final TypeDiffInstruction<Z> instruction;
        private final List<Z> workList;
        private final Map<Object, Object> toStateKeys;
        private final Map<Object, Z> fromStateObjects;
        private final DiffSerializationFramework framework;

        public TypeDiffCallable(DiffSerializationFramework framework, TypeDiffInstruction<Z> instruction, Map<Object, Z> fromStateObjects, Map<Object, Object> toStateKeys, List<Z> workList) {
            this.framework = framework;
            this.instruction = instruction;
            this.fromStateObjects = fromStateObjects;
            this.toStateKeys = toStateKeys;
            this.workList = workList;
        }

        @Override
        public TypeDiff<Z> call() throws Exception {
            TypeDiff<Z> diff = new TypeDiff<Z>(this.instruction.getTypeIdentifier());
            NFTypeSerializer typeSerializer = this.framework.getSerializer(this.instruction.getSerializerName());
            DiffRecord fromRec = new DiffRecord();
            fromRec.setSchema(typeSerializer.getFastBlobSchema());
            DiffRecord toRec = new DiffRecord();
            toRec.setSchema(typeSerializer.getFastBlobSchema());
            fromRec.setTopLevelSerializerName(this.instruction.getSerializerName());
            toRec.setTopLevelSerializerName(this.instruction.getSerializerName());
            for (Z toObject : this.workList) {
                diff.incrementTo();
                Object toStateKey = this.instruction.getKey(toObject);
                this.toStateKeys.put(toStateKey, Boolean.TRUE);
                Z fromObject = this.fromStateObjects.get(toStateKey);
                if (fromObject == null) {
                    diff.addExtraInTo(toObject);
                    continue;
                }
                int diffScore = this.diffFields(diff, fromRec, toRec, typeSerializer, toObject, fromObject);
                if (diffScore <= 0) continue;
                diff.addDiffObject(fromObject, toObject, diffScore);
            }
            return diff;
        }

        private int diffFields(TypeDiff<Z> diff, DiffRecord fromRec, DiffRecord toRec, NFTypeSerializer<Z> typeSerializer, Z toObject, Z fromObject) {
            typeSerializer.serialize(toObject, toRec);
            typeSerializer.serialize(fromObject, fromRec);
            int diffScore = this.incrementDiffFields(diff, toRec, fromRec, toObject, fromObject);
            toRec.clear();
            fromRec.clear();
            return diffScore;
        }

        private int incrementDiffFields(TypeDiff<Z> diff, DiffRecord toRecord, DiffRecord fromRecord, Z toObject, Z fromObject) {
            int objectDiffScore = 0;
            for (DiffPropertyPath key : toRecord.getFieldValues().keySet()) {
                int objectFieldDiffScore;
                List<Object> toObjects = toRecord.getFieldValues().getList(key);
                List<Object> fromObjects = fromRecord.getFieldValues().getList(key);
                if (fromObjects == null) {
                    diff.incrementFieldScores(key, toObjects.size(), toObjects.size());
                    objectFieldDiffScore = toObjects.size();
                } else {
                    objectFieldDiffScore = this.incrementDiffFields(diff, key, toObjects, fromObjects);
                }
                objectDiffScore += objectFieldDiffScore;
                diff.addFieldObjectDiffScore(key, toObject, fromObject, objectFieldDiffScore);
            }
            for (DiffPropertyPath key : fromRecord.getFieldValues().keySet()) {
                if (toRecord.getFieldValues().getList(key) != null) continue;
                int diffSize = fromRecord.getFieldValues().getList(key).size();
                diff.incrementFieldScores(key, diffSize, diffSize);
                objectDiffScore += diffSize;
                diff.addFieldObjectDiffScore(key, toObject, fromObject, diffSize);
            }
            return objectDiffScore;
        }

        private int incrementDiffFields(TypeDiff<?> diff, DiffPropertyPath breadcrumbs, List<Object> toObjects, List<Object> fromObjects) {
            int objectFieldDiffScore = 0;
            Map objectSet = TypeDiffOperation.this.getObjectMap();
            for (Object object : toObjects) {
                this.increment(objectSet, object);
            }
            for (Object object : fromObjects) {
                if (this.decrement(objectSet, object)) continue;
                ++objectFieldDiffScore;
            }
            if (!objectSet.isEmpty()) {
                for (Map.Entry entry : objectSet.entrySet()) {
                    objectFieldDiffScore += ((MutableInt)entry.getValue()).intValue();
                }
            }
            objectSet.clear();
            diff.incrementFieldScores(breadcrumbs, objectFieldDiffScore, toObjects.size() + fromObjects.size());
            return objectFieldDiffScore;
        }

        private void increment(Map<Object, MutableInt> map, Object obj) {
            MutableInt i = map.get(obj);
            if (i == null) {
                i = new MutableInt(0);
                map.put(obj, i);
            }
            i.increment();
        }

        private boolean decrement(Map<Object, MutableInt> map, Object obj) {
            MutableInt i = map.get(obj);
            if (i == null) {
                return false;
            }
            i.decrement();
            if (i.intValue() == 0) {
                map.remove(obj);
            }
            return true;
        }
    }
}

