/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff.history;

import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.diff.history.DiffHistoricalTypeState;
import com.netflix.zeno.util.collections.impl.OpenAddressingArraySet;
import com.netflix.zeno.util.collections.impl.OpenAddressingHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DiffHistoricalState {
    private final String version;
    private final Map<String, DiffHistoricalTypeState<?, ?>> typeStates;

    public DiffHistoricalState(String version) {
        this.version = version;
        this.typeStates = new ConcurrentHashMap();
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getTypes() {
        return this.typeStates.keySet();
    }

    public <K, V> DiffHistoricalTypeState<K, V> getTypeState(String objectType) {
        return this.typeStates.get(objectType);
    }

    public int numTotalChanges() {
        int totalChanges = 0;
        for (Map.Entry<String, DiffHistoricalTypeState<?, ?>> entry : this.typeStates.entrySet()) {
            totalChanges += entry.getValue().numChanges();
        }
        return totalChanges;
    }

    public <K, V> void addTypeState(TypeDiffInstruction<?> typeInstruction, Map<K, V> from, Map<K, V> to) {
        String typeIdentifier = typeInstruction.getTypeIdentifier();
        boolean isGroupOfObjects = !typeInstruction.isUniqueKey();
        this.typeStates.put(typeIdentifier, this.createTypeState(from, to, isGroupOfObjects));
    }

    private <K, V> DiffHistoricalTypeState<K, V> createTypeState(Map<K, V> from, Map<K, V> to, boolean isGroupOfObjects) {
        int newCounter = 0;
        int diffCounter = 0;
        int deleteCounter = 0;
        for (K key : from.keySet()) {
            V toValue = to.get(key);
            if (toValue == null) {
                ++deleteCounter;
                continue;
            }
            V fromValue = from.get(key);
            if (this.checkEquality(toValue, fromValue, isGroupOfObjects)) continue;
            ++diffCounter;
        }
        for (K key : to.keySet()) {
            if (from.containsKey(key)) continue;
            ++newCounter;
        }
        OpenAddressingArraySet<K> newSet = new OpenAddressingArraySet<K>();
        OpenAddressingHashMap<K, V> diffMap = new OpenAddressingHashMap<K, V>();
        OpenAddressingHashMap<K, V> deleteMap = new OpenAddressingHashMap<K, V>();
        newSet.builderInit(newCounter);
        diffMap.builderInit(diffCounter);
        deleteMap.builderInit(deleteCounter);
        deleteCounter = 0;
        diffCounter = 0;
        newCounter = 0;
        for (K key : from.keySet()) {
            V fromValue = from.get(key);
            V toValue = to.get(key);
            if (toValue == null) {
                deleteMap.builderPut(deleteCounter++, key, fromValue);
                continue;
            }
            if (this.checkEquality(toValue, fromValue, isGroupOfObjects)) continue;
            diffMap.builderPut(diffCounter++, key, fromValue);
        }
        for (K key : to.keySet()) {
            if (from.containsKey(key)) continue;
            newSet.builderSet(newCounter++, key);
        }
        newSet.builderFinish();
        diffMap.builderFinish();
        deleteMap.builderFinish();
        return new DiffHistoricalTypeState(newSet, diffMap, deleteMap);
    }

    private boolean checkEquality(Object o1, Object o2, boolean isGroupOfObjects) {
        if (isGroupOfObjects) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (l1.get(i) == l2.get(i)) continue;
                return false;
            }
            return true;
        }
        return o1 == o2;
    }
}

