/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff.history;

import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.util.collections.impl.OpenAddressingHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;

public class DiffHistoryDataState {
    private final String version;
    private final TypeDiffInstruction<?>[] typeInstructions;
    private final Map<String, Map<?, ?>> typeStates;

    public DiffHistoryDataState(FastBlobStateEngine stateEngine, TypeDiffInstruction<?> ... typeInstructions) {
        this.version = stateEngine.getLatestVersion();
        this.typeInstructions = typeInstructions;
        this.typeStates = new HashMap();
        for (TypeDiffInstruction<?> instruction : typeInstructions) {
            FastBlobTypeDeserializationState typeState = stateEngine.getTypeDeserializationState(instruction.getSerializerName());
            this.addTypeState(typeState, instruction);
        }
    }

    private <T> void addTypeState(FastBlobTypeDeserializationState<T> deserializationState, TypeDiffInstruction<T> instruction) {
        if (instruction.isUniqueKey()) {
            this.buildUniqueKeyTypeState(deserializationState, instruction);
        } else {
            this.buildGroupedTypeState(deserializationState, instruction);
        }
    }

    private <T> void buildUniqueKeyTypeState(FastBlobTypeDeserializationState<T> deserializationState, TypeDiffInstruction<T> instruction) {
        OpenAddressingHashMap<Object, T> typeState = new OpenAddressingHashMap<Object, T>();
        typeState.builderInit(deserializationState.countObjects());
        int counter = 0;
        for (T obj : deserializationState) {
            Object key = instruction.getKeyFromObject(obj);
            typeState.builderPut(counter++, key, obj);
        }
        typeState.builderFinish();
        this.typeStates.put(instruction.getTypeIdentifier(), typeState);
    }

    private <T> void buildGroupedTypeState(FastBlobTypeDeserializationState<T> deserializationState, TypeDiffInstruction<T> instruction) {
        Map<Object, MutableInt> countsByKey = this.countObjectsByKey(deserializationState, instruction);
        Map<Object, List<T>> groupsByKey = this.groupObjectsByKey(deserializationState, instruction, countsByKey);
        OpenAddressingHashMap<Object, List<T>> typeState = this.buildNewTypeState(groupsByKey);
        this.typeStates.put(instruction.getTypeIdentifier(), typeState);
    }

    private <T> OpenAddressingHashMap<Object, List<T>> buildNewTypeState(Map<Object, List<T>> groupsByKey) {
        OpenAddressingHashMap<Object, List<T>> typeState = new OpenAddressingHashMap<Object, List<T>>();
        typeState.builderInit(groupsByKey.size());
        int counter = 0;
        for (Map.Entry<Object, List<T>> entry : groupsByKey.entrySet()) {
            typeState.builderPut(counter++, entry.getKey(), entry.getValue());
        }
        typeState.builderFinish();
        return typeState;
    }

    private <T> Map<Object, List<T>> groupObjectsByKey(FastBlobTypeDeserializationState<T> deserializationState, TypeDiffInstruction<T> instruction, Map<Object, MutableInt> countsByKey) {
        HashMap<Object, List<T>> groupsByKey = new HashMap<Object, List<T>>(countsByKey.size());
        for (T obj : deserializationState) {
            Object key = instruction.getKeyFromObject(obj);
            ArrayList<T> groupList = (ArrayList<T>)groupsByKey.get(key);
            if (groupList == null) {
                int count = countsByKey.get(key).intValue();
                groupList = new ArrayList<T>(count);
                groupsByKey.put(key, groupList);
            }
            groupList.add(obj);
        }
        return groupsByKey;
    }

    private <T> Map<Object, MutableInt> countObjectsByKey(FastBlobTypeDeserializationState<T> deserializationState, TypeDiffInstruction<T> instruction) {
        HashMap<Object, MutableInt> countsByKey = new HashMap<Object, MutableInt>(deserializationState.countObjects());
        for (T obj : deserializationState) {
            Object key = instruction.getKeyFromObject(obj);
            MutableInt count = (MutableInt)countsByKey.get(key);
            if (count == null) {
                count = new MutableInt(0);
                countsByKey.put(key, count);
            }
            count.increment();
        }
        return countsByKey;
    }

    public TypeDiffInstruction<?>[] getTypeDiffInstructions() {
        return this.typeInstructions;
    }

    public String getVersion() {
        return this.version;
    }

    public <K, V> Map<K, V> getTypeState(String name) {
        return this.typeStates.get(name);
    }
}

