/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.diff.history;

import com.netflix.zeno.diff.DiffInstruction;
import com.netflix.zeno.diff.TypeDiffInstruction;
import com.netflix.zeno.diff.history.DiffHistoricalState;
import com.netflix.zeno.diff.history.DiffHistoricalTypeState;
import com.netflix.zeno.diff.history.DiffHistoryDataState;
import com.netflix.zeno.diff.history.DiffObjectHistoricalTransition;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.util.SimultaneousExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DiffHistoryTracker {
    private final int historySizeToKeep;
    private final FastBlobStateEngine stateEngine;
    private final LinkedList<DiffHistoricalState> historicalStates;
    private final Map<String, Map<String, String>> historicalStateHeaderTags;
    private final TypeDiffInstruction<?>[] typeDiffInstructions;
    private DiffHistoryDataState currentDataState;

    public DiffHistoryTracker(int numStatesToKeep, FastBlobStateEngine stateEngine, DiffInstruction diffInstruction) {
        this.historySizeToKeep = numStatesToKeep;
        this.stateEngine = stateEngine;
        this.historicalStates = new LinkedList();
        this.historicalStateHeaderTags = new ConcurrentHashMap<String, Map<String, String>>();
        this.typeDiffInstructions = diffInstruction.getTypeInstructions();
    }

    public void addState() {
        DiffHistoryDataState nextState = new DiffHistoryDataState(this.stateEngine, this.typeDiffInstructions);
        if (this.currentDataState != null) {
            this.newHistoricalState(this.currentDataState, nextState);
        }
        this.currentDataState = nextState;
    }

    private void newHistoricalState(final DiffHistoryDataState from, final DiffHistoryDataState to) {
        final DiffHistoricalState historicalState = new DiffHistoricalState(to.getVersion());
        SimultaneousExecutor executor = new SimultaneousExecutor();
        for (final TypeDiffInstruction<?> typeInstruction : from.getTypeDiffInstructions()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Map fromTypeState = from.getTypeState(typeInstruction.getTypeIdentifier());
                    Map toTypeState = to.getTypeState(typeInstruction.getTypeIdentifier());
                    historicalState.addTypeState(typeInstruction, fromTypeState, toTypeState);
                }
            });
        }
        executor.awaitUninterruptibly();
        this.historicalStates.addFirst(historicalState);
        this.historicalStateHeaderTags.put(to.getVersion(), new HashMap<String, String>(this.stateEngine.getHeaderTags()));
        if (this.historicalStates.size() > this.historySizeToKeep) {
            DiffHistoricalState removedState = this.historicalStates.removeLast();
            this.historicalStateHeaderTags.remove(removedState.getVersion());
        }
    }

    public <T> List<DiffObjectHistoricalTransition<T>> getObjectHistory(String type, Object key) {
        ArrayList<DiffObjectHistoricalTransition<T>> states = new ArrayList<DiffObjectHistoricalTransition<T>>(this.historicalStates.size());
        Map typeState = this.currentDataState.getTypeState(type);
        Object currentItem = typeState.get(key);
        for (DiffHistoricalState state : this.historicalStates) {
            DiffHistoricalTypeState historicalState = state.getTypeState(type);
            Map diffObjects = historicalState.getDiffObjects();
            Map deletedObjects = historicalState.getDeletedObjects();
            Set newObjects = historicalState.getNewObjects();
            Object previous = diffObjects.containsKey(key) ? diffObjects.get(key) : (deletedObjects.containsKey(key) ? deletedObjects.get(key) : (newObjects.contains(key) ? null : currentItem));
            states.add(new DiffObjectHistoricalTransition(state.getVersion(), previous, currentItem));
            currentItem = previous;
        }
        return states;
    }

    public List<DiffHistoricalState> getHistoricalStates() {
        return Collections.unmodifiableList(this.historicalStates);
    }

    public Map<String, String> getHistoricalStateHeaderTags(String stateVersion) {
        return this.historicalStateHeaderTags.get(stateVersion);
    }
}

