/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob;

import com.netflix.zeno.fastblob.FastBlobFrameworkSerializer;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.FastBlobDeserializationRecord;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.serializer.FrameworkDeserializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.util.collections.CollectionImplementation;
import com.netflix.zeno.util.collections.MinimizedUnmodifiableCollections;
import com.netflix.zeno.util.collections.builder.ListBuilder;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.builder.SetBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class FastBlobFrameworkDeserializer
extends FrameworkDeserializer<FastBlobDeserializationRecord> {
    private MinimizedUnmodifiableCollections minimizedCollections = new MinimizedUnmodifiableCollections(CollectionImplementation.JAVA_UTIL);
    private final ThreadLocal<char[]> chararr = new ThreadLocal();

    public FastBlobFrameworkDeserializer(FastBlobStateEngine framework) {
        super(framework);
    }

    public void setCollectionImplementation(CollectionImplementation impl) {
        this.minimizedCollections = new MinimizedUnmodifiableCollections(impl);
    }

    @Override
    public Boolean deserializeBoolean(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        return byteData.get(fieldPosition) == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean deserializePrimitiveBoolean(FastBlobDeserializationRecord rec, String fieldName) {
        long fieldPosition;
        ByteData byteData = rec.getByteData();
        return byteData.get(fieldPosition = rec.getPosition(fieldName)) == 1;
    }

    @Override
    public Integer deserializeInteger(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int value = VarInt.readVInt(byteData, fieldPosition);
        return value >>> 1 ^ value << 31 >> 31;
    }

    @Override
    public int deserializePrimitiveInt(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        int value = VarInt.readVInt(byteData, fieldPosition);
        return value >>> 1 ^ value << 31 >> 31;
    }

    @Override
    public Long deserializeLong(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        long value = VarInt.readVLong(byteData, fieldPosition);
        return value >>> 1 ^ value << 63 >> 63;
    }

    @Override
    public long deserializePrimitiveLong(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        long value = VarInt.readVLong(byteData, fieldPosition);
        return value >>> 1 ^ value << 63 >> 63;
    }

    @Override
    public Float deserializeFloat(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        int intBits = this.readIntBits(byteData, fieldPosition);
        if (intBits == FastBlobFrameworkSerializer.NULL_FLOAT_BITS) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(intBits));
    }

    @Override
    public float deserializePrimitiveFloat(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        int intBits = this.readIntBits(byteData, fieldPosition);
        return Float.intBitsToFloat(intBits);
    }

    private int readIntBits(ByteData byteData, long fieldPosition) {
        int intBits = (byteData.get(fieldPosition++) & 0xFF) << 24;
        intBits |= (byteData.get(fieldPosition++) & 0xFF) << 16;
        intBits |= (byteData.get(fieldPosition++) & 0xFF) << 8;
        return intBits |= byteData.get(fieldPosition) & 0xFF;
    }

    @Override
    public Double deserializeDouble(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        long longBits = this.readLongBits(byteData, fieldPosition);
        if (longBits == FastBlobFrameworkSerializer.NULL_DOUBLE_BITS) {
            return null;
        }
        return Double.longBitsToDouble(longBits);
    }

    @Override
    public double deserializePrimitiveDouble(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        long longBits = this.readLongBits(byteData, fieldPosition);
        return Double.longBitsToDouble(longBits);
    }

    private long readLongBits(ByteData byteData, long fieldPosition) {
        long longBits = (long)(byteData.get(fieldPosition++) & 0xFF) << 56;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 48;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 40;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 32;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 24;
        longBits |= (long)((byteData.get(fieldPosition++) & 0xFF) << 16);
        longBits |= (long)((byteData.get(fieldPosition++) & 0xFF) << 8);
        return longBits |= (long)(byteData.get(fieldPosition) & 0xFF);
    }

    @Override
    public String deserializeString(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        return this.readString(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
    }

    @Override
    public byte[] deserializeBytes(FastBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        fieldPosition += (long)VarInt.sizeOfVInt(length);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = byteData.get(fieldPosition++);
        }
        return data;
    }

    @Override
    public <T> T deserializeObject(FastBlobDeserializationRecord rec, String fieldName, Class<T> clazz) {
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        return this.deserializeObject(rec, fieldPosition, rec.getObjectType(fieldName));
    }

    @Override
    @Deprecated
    public <T> T deserializeObject(FastBlobDeserializationRecord rec, String fieldName, String typeName, Class<T> clazz) {
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        return this.deserializeObject(rec, fieldPosition, typeName);
    }

    private <T> T deserializeObject(FastBlobDeserializationRecord rec, long fieldPosition, String typeName) {
        ByteData byteData = rec.getByteData();
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int ordinal = VarInt.readVInt(byteData, fieldPosition);
        FastBlobTypeDeserializationState deserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(typeName);
        return deserializationState.get(ordinal);
    }

    @Override
    public <T> List<T> deserializeList(FastBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<T> itemSerializer) {
        int length;
        int numElements;
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        if ((numElements = VarInt.countVarIntsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length = VarInt.readVInt(byteData, fieldPosition)), length)) == 0) {
            return Collections.emptyList();
        }
        ListBuilder list = this.minimizedCollections.createListBuilder();
        list.builderInit(numElements);
        FastBlobTypeDeserializationState elementDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(itemSerializer.getName());
        for (int i = 0; i < numElements; ++i) {
            if (VarInt.readVNull(byteData, fieldPosition)) {
                list.builderSet(i, null);
                ++fieldPosition;
                continue;
            }
            int ordinal = VarInt.readVInt(byteData, fieldPosition);
            fieldPosition += (long)VarInt.sizeOfVInt(ordinal);
            Object element = elementDeserializationState.get(ordinal);
            if (element == null) continue;
            list.builderSet(i, element);
        }
        return this.minimizedCollections.minimizeList(list.builderFinish());
    }

    @Override
    public <T> Set<T> deserializeSet(FastBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<T> itemSerializer) {
        int length;
        int numElements;
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        if ((numElements = VarInt.countVarIntsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length = VarInt.readVInt(byteData, fieldPosition)), length)) == 0) {
            return Collections.emptySet();
        }
        SetBuilder set = this.minimizedCollections.createSetBuilder();
        set.builderInit(numElements);
        FastBlobTypeDeserializationState elementDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(itemSerializer.getName());
        int previousOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
                set.builderSet(i, null);
                continue;
            }
            int ordinal = VarInt.readVInt(byteData, fieldPosition);
            fieldPosition += (long)VarInt.sizeOfVInt(ordinal);
            previousOrdinal = ordinal += previousOrdinal;
            Object element = elementDeserializationState.get(ordinal);
            if (element == null) continue;
            set.builderSet(i, element);
        }
        return this.minimizedCollections.minimizeSet(set.builderFinish());
    }

    @Override
    public <K, V> Map<K, V> deserializeMap(FastBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        int numElements = VarInt.countVarIntsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
        if ((numElements /= 2) == 0) {
            return Collections.emptyMap();
        }
        MapBuilder map = this.minimizedCollections.createMapBuilder();
        map.builderInit(numElements);
        FastBlobTypeDeserializationState keyDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(keySerializer.getName());
        FastBlobTypeDeserializationState valueDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(valueSerializer.getName());
        this.populateMap(byteData, fieldPosition, numElements, map, keyDeserializationState, valueDeserializationState);
        return this.minimizedCollections.minimizeMap(map.builderFinish());
    }

    @Override
    public <K, V> SortedMap<K, V> deserializeSortedMap(FastBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        int numElements = VarInt.countVarIntsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
        if ((numElements /= 2) == 0) {
            return this.minimizedCollections.emptySortedMap();
        }
        MapBuilder map = this.minimizedCollections.createSortedMapBuilder();
        map.builderInit(numElements);
        FastBlobTypeDeserializationState keyDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(keySerializer.getName());
        FastBlobTypeDeserializationState valueDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(valueSerializer.getName());
        this.populateMap(byteData, fieldPosition, numElements, map, keyDeserializationState, valueDeserializationState);
        return this.minimizedCollections.minimizeSortedMap((SortedMap)map.builderFinish());
    }

    private <K, V> void populateMap(ByteData byteData, long fieldPosition, int numElements, MapBuilder<K, V> mapToPopulate, FastBlobTypeDeserializationState<K> keyState, FastBlobTypeDeserializationState<V> valueState) {
        int previousValueOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            Object key = null;
            Object value = null;
            boolean undefinedKeyOrValue = false;
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                int keyOrdinal = VarInt.readVInt(byteData, fieldPosition);
                fieldPosition += (long)VarInt.sizeOfVInt(keyOrdinal);
                key = keyState.get(keyOrdinal);
                if (key == null) {
                    undefinedKeyOrValue = true;
                }
            }
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                int valueOrdinal = VarInt.readVInt(byteData, fieldPosition);
                fieldPosition += (long)VarInt.sizeOfVInt(valueOrdinal);
                previousValueOrdinal = valueOrdinal += previousValueOrdinal;
                value = valueState.get(valueOrdinal);
                if (value == null) {
                    undefinedKeyOrValue = true;
                }
            }
            if (undefinedKeyOrValue) continue;
            mapToPopulate.builderPut(i, key, value);
        }
    }

    protected String readString(ByteData data, long position, int length) {
        long endPosition = position + (long)length;
        char[] chararr = this.getCharArray();
        if (length > chararr.length) {
            chararr = new char[length];
        }
        int count = 0;
        while (position < endPosition) {
            int c = VarInt.readVInt(data, position);
            chararr[count++] = (char)c;
            position += (long)VarInt.sizeOfVInt(c);
        }
        return new String(chararr, 0, count);
    }

    private char[] getCharArray() {
        char[] ch = this.chararr.get();
        if (ch == null) {
            ch = new char[100];
            this.chararr.set(ch);
        }
        return ch;
    }
}

