/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobSerializationRecord;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.state.FastBlobTypeSerializationState;
import com.netflix.zeno.serializer.FrameworkSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FastBlobFrameworkSerializer
extends FrameworkSerializer<FastBlobSerializationRecord> {
    public static final int NULL_FLOAT_BITS = Float.floatToIntBits(Float.NaN) + 1;
    public static final long NULL_DOUBLE_BITS = Double.doubleToLongBits(Double.NaN) + 1L;

    public FastBlobFrameworkSerializer(FastBlobStateEngine framework) {
        super(framework);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Integer) {
            this.serializePrimitive(rec, fieldName, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.serializePrimitive(rec, fieldName, (long)((Long)value));
        } else if (value instanceof Float) {
            this.serializePrimitive(rec, fieldName, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.serializePrimitive(rec, fieldName, (double)((Double)value));
        } else if (value instanceof Boolean) {
            this.serializePrimitive(rec, fieldName, (boolean)((Boolean)value));
        } else if (value instanceof String) {
            this.serializeString(rec, fieldName, (String)value);
        } else if (value instanceof byte[]) {
            this.serializeBytes(rec, fieldName, (byte[])value);
        } else {
            throw new RuntimeException("Primitive type " + value.getClass().getSimpleName() + " not supported!");
        }
    }

    public void serializeString(FastBlobSerializationRecord rec, String fieldName, String value) {
        if (value == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.STRING) {
            throw new IllegalArgumentException("Attempting to serialize a String as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        this.writeString(value, fieldBuffer);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, int value) {
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.INT && fieldType != FastBlobSchema.FieldType.LONG) {
            throw new IllegalArgumentException("Attempting to serialize an int as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        VarInt.writeVInt(fieldBuffer, value << 1 ^ value >> 31);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, long value) {
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.LONG) {
            throw new IllegalArgumentException("Attempting to serialize a long as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        VarInt.writeVLong(fieldBuffer, value << 1 ^ value >> 63);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, float value) {
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.FLOAT) {
            throw new IllegalArgumentException("Attempting to serialize a float as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        int intBits = Float.floatToIntBits(value);
        FastBlobFrameworkSerializer.writeFixedLengthInt(fieldBuffer, intBits);
    }

    public static void writeNullFloat(ByteDataBuffer fieldBuffer) {
        FastBlobFrameworkSerializer.writeFixedLengthInt(fieldBuffer, NULL_FLOAT_BITS);
    }

    private static void writeFixedLengthInt(ByteDataBuffer fieldBuffer, int intBits) {
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, double value) {
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.DOUBLE) {
            throw new IllegalArgumentException("Attempting to serialize a double as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        long intBits = Double.doubleToLongBits(value);
        FastBlobFrameworkSerializer.writeFixedLengthLong(fieldBuffer, intBits);
    }

    public static void writeNullDouble(ByteDataBuffer fieldBuffer) {
        FastBlobFrameworkSerializer.writeFixedLengthLong(fieldBuffer, NULL_DOUBLE_BITS);
    }

    private static void writeFixedLengthLong(ByteDataBuffer fieldBuffer, long intBits) {
        fieldBuffer.write((byte)(intBits >>> 56));
        fieldBuffer.write((byte)(intBits >>> 48));
        fieldBuffer.write((byte)(intBits >>> 40));
        fieldBuffer.write((byte)(intBits >>> 32));
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    @Override
    public void serializePrimitive(FastBlobSerializationRecord rec, String fieldName, boolean value) {
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.BOOLEAN) {
            throw new IllegalArgumentException("Attempting to serialize a boolean as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        byte byteValue = value ? (byte)1 : 0;
        fieldBuffer.write(byteValue);
    }

    @Override
    public void serializeBytes(FastBlobSerializationRecord rec, String fieldName, byte[] value) {
        if (value == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.BYTES) {
            throw new IllegalArgumentException("Attempting to serialize a byte array as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        for (int i = 0; i < value.length; ++i) {
            fieldBuffer.write(value[i]);
        }
    }

    @Override
    @Deprecated
    public void serializeObject(FastBlobSerializationRecord rec, String fieldName, String typeName, Object obj) {
        int position = rec.getSchema().getPosition(fieldName);
        this.validateField(fieldName, position);
        this.serializeObject(rec, position, fieldName, typeName, obj);
    }

    private void validateField(String fieldName, int position) {
        if (position == -1) {
            throw new IllegalArgumentException("Attempting to serialize non existent field " + fieldName + ".");
        }
    }

    protected void serializeObject(FastBlobSerializationRecord rec, int position, String fieldName, String typeName, Object obj) {
        if (obj == null) {
            return;
        }
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.OBJECT) {
            throw new IllegalArgumentException("Attempting to serialize an Object as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeSerializationState<Object> typeSerializationState = ((FastBlobStateEngine)this.framework).getTypeSerializationState(typeName);
        int ordinal = typeSerializationState.add(obj, rec.getImageMembershipsFlags());
        VarInt.writeVInt(fieldBuffer, ordinal);
    }

    @Override
    public void serializeObject(FastBlobSerializationRecord rec, String fieldName, Object obj) {
        int position = rec.getSchema().getPosition(fieldName);
        this.validateField(fieldName, position);
        this.serializeObject(rec, position, fieldName, rec.getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(FastBlobSerializationRecord rec, String fieldName, String typeName, Collection<T> collection) {
        if (collection == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.LIST && fieldType != FastBlobSchema.FieldType.COLLECTION) {
            throw new IllegalArgumentException("Attempting to serialize a List as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeSerializationState<T> typeSerializationState = ((FastBlobStateEngine)this.framework).getTypeSerializationState(typeName);
        for (T obj : collection) {
            if (obj == null) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            int ordinal = typeSerializationState.add(obj, rec.getImageMembershipsFlags());
            VarInt.writeVInt(fieldBuffer, ordinal);
        }
    }

    @Override
    public <T> void serializeSet(FastBlobSerializationRecord rec, String fieldName, String typeName, Set<T> set) {
        if (set == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.SET && fieldType != FastBlobSchema.FieldType.COLLECTION) {
            throw new IllegalArgumentException("Attempting to serialize a Set as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeSerializationState<T> typeSerializationState = ((FastBlobStateEngine)this.framework).getTypeSerializationState(typeName);
        int[] setOrdinals = new int[set.size()];
        int i = 0;
        for (T obj : set) {
            if (obj == null) {
                setOrdinals[i++] = -1;
                continue;
            }
            setOrdinals[i++] = typeSerializationState.add(obj, rec.getImageMembershipsFlags());
        }
        if (setOrdinals.length > i) {
            setOrdinals = Arrays.copyOf(setOrdinals, i);
        }
        Arrays.sort(setOrdinals);
        int currentOrdinal = 0;
        for (i = 0; i < setOrdinals.length; ++i) {
            if (setOrdinals[i] == -1) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            VarInt.writeVInt(fieldBuffer, setOrdinals[i] - currentOrdinal);
            currentOrdinal = setOrdinals[i];
        }
    }

    @Override
    public <K, V> void serializeMap(FastBlobSerializationRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> map) {
        if (map == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.MAP) {
            throw new IllegalArgumentException("Attempting to serialize a Map as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeSerializationState<K> keySerializationState = ((FastBlobStateEngine)this.framework).getTypeSerializationState(keyTypeName);
        FastBlobTypeSerializationState<V> valueSerializationState = ((FastBlobStateEngine)this.framework).getTypeSerializationState(valueTypeName);
        long[] mapEntries = new long[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int keyOrdinal = -1;
            int valueOrdinal = -1;
            if (entry.getKey() != null) {
                keyOrdinal = keySerializationState.add(entry.getKey(), rec.getImageMembershipsFlags());
            }
            if (entry.getValue() != null) {
                valueOrdinal = valueSerializationState.add(entry.getValue(), rec.getImageMembershipsFlags());
            }
            mapEntries[i++] = (long)valueOrdinal << 32 | (long)keyOrdinal & 0xFFFFFFFFL;
        }
        if (mapEntries.length > i) {
            mapEntries = Arrays.copyOf(mapEntries, i);
        }
        Arrays.sort(mapEntries);
        int currentValueOrdinal = 0;
        for (i = 0; i < mapEntries.length; ++i) {
            int keyOrdinal = (int)mapEntries[i];
            int valueOrdinal = (int)(mapEntries[i] >> 32);
            if (keyOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
            } else {
                VarInt.writeVInt(fieldBuffer, keyOrdinal);
            }
            if (valueOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            VarInt.writeVInt(fieldBuffer, valueOrdinal - currentValueOrdinal);
            currentValueOrdinal = valueOrdinal;
        }
    }

    protected void writeString(String str, ByteDataBuffer out) {
        for (int i = 0; i < str.length(); ++i) {
            VarInt.writeVInt(out, (int)str.charAt(i));
        }
    }
}

