/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob;

import com.netflix.zeno.fastblob.FastBlobFrameworkSerializer;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobSerializationRecord;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FastBlobHeapFriendlyClientFrameworkSerializer
extends FastBlobFrameworkSerializer {
    private boolean checkSerializationIntegrity = false;
    private boolean serializationIntegrityFlawed = false;

    public FastBlobHeapFriendlyClientFrameworkSerializer(FastBlobStateEngine framework) {
        super(framework);
    }

    @Override
    protected void serializeObject(FastBlobSerializationRecord rec, int position, String fieldName, String typeName, Object obj) {
        if (obj == null) {
            return;
        }
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.OBJECT) {
            throw new IllegalArgumentException("Attempting to serialize an Object as " + (Object)((Object)fieldType) + " in field " + fieldName + ".  Carefully check your schema for type " + rec.getSchema().getName() + ".");
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeDeserializationState<Object> deserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(typeName);
        int ordinal = this.findObject(deserializationState, obj, fieldName);
        VarInt.writeVInt(fieldBuffer, ordinal);
    }

    @Override
    public <T> void serializeList(FastBlobSerializationRecord rec, String fieldName, String typeName, Collection<T> collection) {
        if (collection == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.LIST && fieldType != FastBlobSchema.FieldType.COLLECTION) {
            throw new IllegalArgumentException("Attempting to serialize a List as " + (Object)((Object)fieldType) + " in field " + fieldName);
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeDeserializationState<Object> deserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(typeName);
        for (T obj : collection) {
            if (obj == null) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            int ordinal = this.findObject(deserializationState, obj, fieldName);
            VarInt.writeVInt(fieldBuffer, ordinal);
        }
    }

    @Override
    public <T> void serializeSet(FastBlobSerializationRecord rec, String fieldName, String typeName, Set<T> set) {
        if (set == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.SET && fieldType != FastBlobSchema.FieldType.COLLECTION) {
            throw new IllegalArgumentException("Attempting to serialize a Set as " + (Object)((Object)fieldType) + " in field " + fieldName);
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeDeserializationState<Object> deserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(typeName);
        int[] setOrdinals = new int[set.size()];
        int i = 0;
        for (T obj : set) {
            setOrdinals[i++] = this.findObject(deserializationState, obj, fieldName);
        }
        Arrays.sort(setOrdinals);
        int currentOrdinal = 0;
        for (i = 0; i < setOrdinals.length; ++i) {
            VarInt.writeVInt(fieldBuffer, setOrdinals[i] - currentOrdinal);
            currentOrdinal = setOrdinals[i];
        }
    }

    @Override
    public <K, V> void serializeMap(FastBlobSerializationRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> map) {
        if (map == null) {
            return;
        }
        int position = rec.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = rec.getSchema().getFieldType(position);
        if (fieldType != FastBlobSchema.FieldType.MAP) {
            throw new IllegalArgumentException("Attempting to serialize a Map as " + (Object)((Object)fieldType) + " in field " + fieldName);
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(position);
        FastBlobTypeDeserializationState<Object> keyDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(keyTypeName);
        FastBlobTypeDeserializationState<Object> valueDeserializationState = ((FastBlobStateEngine)this.framework).getTypeDeserializationState(valueTypeName);
        long[] mapEntries = new long[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int keyOrdinal = -1;
            int valueOrdinal = -1;
            if (entry.getKey() != null) {
                keyOrdinal = this.findObject(keyDeserializationState, entry.getKey(), fieldName + "(key)");
            }
            if (entry.getValue() != null) {
                valueOrdinal = this.findObject(valueDeserializationState, entry.getValue(), fieldName + "(value)");
            }
            mapEntries[i++] = (long)valueOrdinal << 32 | (long)keyOrdinal & 0xFFFFFFFFL;
        }
        Arrays.sort(mapEntries);
        int currentValueOrdinal = 0;
        for (i = 0; i < mapEntries.length; ++i) {
            int keyOrdinal = (int)mapEntries[i];
            int valueOrdinal = (int)(mapEntries[i] >> 32);
            if (keyOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
            } else {
                VarInt.writeVInt(fieldBuffer, keyOrdinal);
            }
            if (valueOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
            } else {
                VarInt.writeVInt(fieldBuffer, valueOrdinal - currentValueOrdinal);
            }
            currentValueOrdinal = valueOrdinal;
        }
    }

    private <T> int findObject(FastBlobTypeDeserializationState<Object> deserializationState, T obj, String fieldName) {
        int ordinal = deserializationState.find(obj);
        if (this.checkSerializationIntegrity && ordinal < 0) {
            this.serializationIntegrityFlawed = true;
        }
        return ordinal;
    }

    public void setCheckSerializationIntegrity(boolean warn) {
        this.checkSerializationIntegrity = warn;
    }

    public boolean isSerializationIntegrityFlawed() {
        return this.serializationIntegrityFlawed;
    }

    public void clearSerializationIntegrityFlawedFlag() {
        this.serializationIntegrityFlawed = false;
    }
}

