/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob;

public class FastBlobImageUtils {
    public static final long ONE_TRUE = FastBlobImageUtils.toLong(true);
    private static final long[] ALL_TRUE_PRIVATE = new long[64];

    public static long toLong(boolean ... a) {
        if (a.length >= 64) {
            throw new IllegalArgumentException("while packing boolean array in int, the array length should be less than 32");
        }
        int n = 0;
        for (int i = a.length - 1; i >= 0; --i) {
            n = n << 1 | (a[i] ? 1 : 0);
        }
        return n;
    }

    public static final long getAllTrue(int count) {
        if (count >= 64) {
            throw new IllegalArgumentException("while packing boolean array in int, the array length should be less than 32");
        }
        return ALL_TRUE_PRIVATE[count];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            boolean[] a = new boolean[i];
            for (int j = 0; j < i; ++j) {
                a[j] = true;
            }
            FastBlobImageUtils.ALL_TRUE_PRIVATE[i] = FastBlobImageUtils.toLong(a);
        }
    }
}

