/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob;

import com.netflix.zeno.fastblob.FastBlobFrameworkDeserializer;
import com.netflix.zeno.fastblob.FastBlobFrameworkSerializer;
import com.netflix.zeno.fastblob.FastBlobHeapFriendlyClientFrameworkSerializer;
import com.netflix.zeno.fastblob.FastBlobImageUtils;
import com.netflix.zeno.fastblob.OrdinalMapping;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.fastblob.state.FastBlobTypeSerializationState;
import com.netflix.zeno.fastblob.state.TypeDeserializationStateListener;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.SerializerFactory;
import com.netflix.zeno.util.SimultaneousExecutor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class FastBlobStateEngine
extends SerializationFramework {
    private final Map<String, FastBlobTypeSerializationState<?>> serializationTypeStates;
    private final Map<String, FastBlobTypeDeserializationState<?>> deserializationTypeStates;
    public final List<FastBlobTypeSerializationState<?>> orderedSerializationStates;
    private final boolean shouldUseObjectIdentityOrdinalCaching;
    private final int numberOfConfigurations;
    private String latestVersion;
    private Map<String, String> headerTags = new HashMap<String, String>();
    private int maxSingleObjectLength;
    private final long addToAllImagesFlags;
    private final int STATE_ENGINE_SERIALIZATION_FORMAT_VERSION = 999996;

    public FastBlobStateEngine(SerializerFactory factory) {
        this(factory, 1, true);
    }

    public FastBlobStateEngine(SerializerFactory factory, int numberOfConfigurations) {
        this(factory, numberOfConfigurations, true);
    }

    public FastBlobStateEngine(SerializerFactory factory, int numberOfConfigurations, boolean shouldUseObjectIdentityOrdinalCaching) {
        super(factory);
        this.shouldUseObjectIdentityOrdinalCaching = shouldUseObjectIdentityOrdinalCaching;
        this.frameworkSerializer = new FastBlobFrameworkSerializer(this);
        this.frameworkDeserializer = new FastBlobFrameworkDeserializer(this);
        this.serializationTypeStates = new HashMap();
        this.deserializationTypeStates = new HashMap();
        this.orderedSerializationStates = new ArrayList();
        this.numberOfConfigurations = numberOfConfigurations;
        this.addToAllImagesFlags = FastBlobImageUtils.getAllTrue(numberOfConfigurations);
        this.createSerializationStates();
    }

    protected void createSerializationStates() {
        for (NFTypeSerializer<?> serializer : this.getOrderedSerializers()) {
            this.createSerializationState(serializer);
        }
    }

    private <T> void createSerializationState(NFTypeSerializer<T> serializer) {
        FastBlobTypeSerializationState<T> serializationState = new FastBlobTypeSerializationState<T>(serializer, this.numberOfConfigurations, this.shouldUseObjectIdentityOrdinalCaching);
        this.serializationTypeStates.put(serializer.getName(), serializationState);
        this.orderedSerializationStates.add(serializationState);
        this.deserializationTypeStates.put(serializer.getName(), new FastBlobTypeDeserializationState<T>(serializer));
    }

    public int getNumberOfConfigurations() {
        return this.numberOfConfigurations;
    }

    public void add(String type, Object obj) {
        this.add(type, obj, this.addToAllImagesFlags);
    }

    @Deprecated
    public void add(String type, Object obj, boolean[] addToImageFlags) {
        this.add(type, obj, FastBlobImageUtils.toLong(addToImageFlags));
    }

    public void add(String type, Object obj, long addToImageFlags) {
        FastBlobTypeSerializationState<Object> typeSerializationState = this.getTypeSerializationState(type);
        if (typeSerializationState == null) {
            throw new RuntimeException("Unable to find type.  Ensure there exists an NFTypeSerializer with the name: " + type);
        }
        typeSerializationState.add(obj, addToImageFlags);
    }

    public <T> void setTypeDeserializationStateListener(String type, TypeDeserializationStateListener<T> listener) {
        FastBlobTypeDeserializationState<T> typeState = this.getTypeDeserializationState(type);
        if (typeState == null) {
            throw new RuntimeException("Unable to find type.  Ensure there exists an NFTypeSerializer with the name: " + type);
        }
        typeState.setListener(listener);
    }

    public List<FastBlobTypeSerializationState<?>> getOrderedSerializationStates() {
        return this.orderedSerializationStates;
    }

    public Set<String> getSerializerNames() {
        return Collections.unmodifiableSet(this.serializationTypeStates.keySet());
    }

    public <T> FastBlobTypeSerializationState<T> getTypeSerializationState(String name) {
        return this.serializationTypeStates.get(name);
    }

    public <T> FastBlobTypeDeserializationState<T> getTypeDeserializationState(String name) {
        return this.deserializationTypeStates.get(name);
    }

    public void prepareForWrite() {
        this.maxSingleObjectLength = 0;
        for (FastBlobTypeSerializationState<?> state : this.orderedSerializationStates) {
            int stateMaxLength = state.prepareForWrite();
            if (stateMaxLength <= this.maxSingleObjectLength) continue;
            this.maxSingleObjectLength = stateMaxLength;
        }
    }

    public void prepareForNextCycle() {
        for (FastBlobTypeSerializationState<?> state : this.orderedSerializationStates) {
            state.prepareForNextCycle();
        }
    }

    public int getMaxSingleObjectLength() {
        return this.maxSingleObjectLength;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public void addHeaderTags(Map<String, String> headerTags) {
        this.headerTags.putAll(headerTags);
    }

    public void addHeaderTag(String tag, String value) {
        this.headerTags.put(tag, value);
    }

    public String getHeaderTag(String tag) {
        return this.headerTags.get(tag);
    }

    public void serializeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(999996);
        dos.writeUTF(this.latestVersion);
        dos.writeShort(this.headerTags.size());
        for (Map.Entry<String, String> entry : this.headerTags.entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeUTF(entry.getValue());
        }
        VarInt.writeVInt(dos, this.numberOfConfigurations);
        VarInt.writeVInt(dos, this.orderedSerializationStates.size());
        for (FastBlobTypeSerializationState fastBlobTypeSerializationState : this.orderedSerializationStates) {
            dos.writeUTF(fastBlobTypeSerializationState.getSchema().getName());
            fastBlobTypeSerializationState.serializeTo(dos);
        }
    }

    public void deserializeFrom(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != 999996) {
            throw new RuntimeException("Refusing to reinstantiate FastBlobStateEngine due to serialized version mismatch.");
        }
        this.latestVersion = dis.readUTF();
        int numHeaderTagEntries = dis.readShort();
        this.headerTags.clear();
        this.headerTags = new HashMap<String, String>();
        for (int i = 0; i < numHeaderTagEntries; ++i) {
            this.headerTags.put(dis.readUTF(), dis.readUTF());
        }
        int numConfigs = VarInt.readVInt(dis);
        int numStates = VarInt.readVInt(dis);
        for (int i = 0; i < numStates; ++i) {
            String typeName = dis.readUTF();
            FastBlobTypeSerializationState<?> typeState = this.serializationTypeStates.get(typeName);
            if (typeState != null) {
                typeState.deserializeFrom(dis, numConfigs);
                continue;
            }
            FastBlobTypeSerializationState.discardSerializedTypeSerializationState(dis, numConfigs);
        }
    }

    public OrdinalMapping copySerializationStatesTo(FastBlobStateEngine otherStateEngine, Collection<String> ignoreSerializers) {
        OrdinalMapping ordinalMapping = new OrdinalMapping();
        for (FastBlobTypeSerializationState fastBlobTypeSerializationState : this.getOrderedSerializationStates()) {
            String serializerName = fastBlobTypeSerializationState.serializer.getName();
            if (ignoreSerializers.contains(serializerName)) continue;
            fastBlobTypeSerializationState.copyTo(otherStateEngine.getTypeSerializationState(serializerName), ordinalMapping);
        }
        return ordinalMapping;
    }

    public void copySpecificSerializationStatesTo(FastBlobStateEngine otherStateEngine, List<String> whichSerializers, OrdinalMapping ordinalMapping) {
        for (String serializerName : whichSerializers) {
            FastBlobTypeSerializationState serializationState = this.getTypeSerializationState(serializerName);
            serializationState.copyTo(otherStateEngine.getTypeSerializationState(serializerName), ordinalMapping);
        }
    }

    public void copyTo(FastBlobStateEngine otherStateEngine) {
        this.copyTo(otherStateEngine, Collections.emptyList());
    }

    public void copyTo(FastBlobStateEngine otherStateEngine, Collection<String> topLevelSerializersToIgnore) {
        this.fillDeserializationStatesFromSerializedData();
        SimultaneousExecutor executor = new SimultaneousExecutor(4.0);
        ArrayList<String> topLevelSerializersToCopy = new ArrayList<String>();
        for (NFTypeSerializer<?> serializer : this.getTopLevelSerializers()) {
            String serializerName = serializer.getName();
            if (topLevelSerializersToIgnore.contains(serializerName)) continue;
            topLevelSerializersToCopy.add(serializer.getName());
        }
        CountDownLatch latch = new CountDownLatch(executor.getMaximumPoolSize() * topLevelSerializersToCopy.size());
        for (String serializerizerName : topLevelSerializersToCopy) {
            executor.submit(this.getFillSerializationStateRunnable(otherStateEngine, serializerizerName, executor, latch));
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        executor.shutdown();
    }

    private Runnable getFillSerializationStateRunnable(final FastBlobStateEngine otherStateEngine, final String serializerName, final SimultaneousExecutor executor, final CountDownLatch latch) {
        return new Runnable(){

            @Override
            public void run() {
                FastBlobStateEngine.this.fillSerializationState(otherStateEngine, serializerName, executor, latch);
            }
        };
    }

    private void fillSerializationState(FastBlobStateEngine otherStateEngine, String serializerName, SimultaneousExecutor executor, CountDownLatch latch) {
        int threadsSize = executor.getMaximumPoolSize();
        for (int i = 0; i < threadsSize; ++i) {
            executor.submit(this.getFillSerializationStatesRunnable(otherStateEngine, serializerName, threadsSize, latch, i));
        }
    }

    private Runnable getFillSerializationStatesRunnable(final FastBlobStateEngine otherStateEngine, final String serializerName, final int numThreads, final CountDownLatch latch, final int threadNumber) {
        return new Runnable(){

            @Override
            public void run() {
                FastBlobStateEngine.this.copyObjects(otherStateEngine, serializerName, numThreads, threadNumber);
                latch.countDown();
            }
        };
    }

    public void fillDeserializationStatesFromSerializedData() {
        for (FastBlobTypeSerializationState fastBlobTypeSerializationState : this.getOrderedSerializationStates()) {
            String serializer = fastBlobTypeSerializationState.getSchema().getName();
            fastBlobTypeSerializationState.fillDeserializationState(this.getTypeDeserializationState(serializer));
        }
    }

    public void fillDeserializationStatesFromSerializedData(Collection<String> includeSerializers) {
        for (FastBlobTypeSerializationState fastBlobTypeSerializationState : this.getOrderedSerializationStates()) {
            String serializer = fastBlobTypeSerializationState.getSchema().getName();
            if (!includeSerializers.contains(serializer)) continue;
            fastBlobTypeSerializationState.fillDeserializationState(this.getTypeDeserializationState(serializer));
        }
    }

    public void fillSerializationStatesFromDeserializedData() {
        for (NFTypeSerializer<?> serializer : this.getTopLevelSerializers()) {
            FastBlobTypeDeserializationState state = this.getTypeDeserializationState(serializer.getName());
            state.fillSerializationState(this);
        }
    }

    public void prepareForDoubleSnapshotRefresh() {
        this.frameworkSerializer = new FastBlobHeapFriendlyClientFrameworkSerializer(this);
    }

    public void cleanUpAfterDoubleSnapshotRefresh() {
        for (FastBlobTypeDeserializationState<?> state : this.deserializationTypeStates.values()) {
            state.clearIdentityOrdinalMap();
        }
    }

    private void copyObjects(FastBlobStateEngine otherStateEngine, String serializerName, int numThreads, int threadNumber) {
        FastBlobTypeDeserializationState typeDeserializationState = this.getTypeDeserializationState(serializerName);
        int maxOrdinal = typeDeserializationState.maxOrdinal() + 1;
        if (maxOrdinal < threadNumber) {
            return;
        }
        FastBlobTypeSerializationState typeSerializationState = this.getTypeSerializationState(serializerName);
        boolean[] imageMembershipsFlags = new boolean[this.numberOfConfigurations];
        for (int i = threadNumber; i < maxOrdinal; i += numThreads) {
            Object obj = typeDeserializationState.get(i);
            if (obj == null) continue;
            for (int imageIndex = 0; imageIndex < this.numberOfConfigurations; ++imageIndex) {
                imageMembershipsFlags[imageIndex] = typeSerializationState.getImageMembershipBitSet(imageIndex).get(i);
            }
            otherStateEngine.add(typeSerializationState.getSchema().getName(), obj, FastBlobImageUtils.toLong(imageMembershipsFlags));
        }
    }
}

