/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.io;

import com.netflix.zeno.fastblob.FastBlobHeapFriendlyClientFrameworkSerializer;
import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.io.FastBlobHeader;
import com.netflix.zeno.fastblob.io.FastBlobHeaderReader;
import com.netflix.zeno.fastblob.io.FastBlobReaderEventHandler;
import com.netflix.zeno.fastblob.io.ZenoFastBlobHeaderReader;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobDeserializationRecord;
import com.netflix.zeno.fastblob.record.FastBlobSerializationRecord;
import com.netflix.zeno.fastblob.record.StreamingByteData;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.state.ByteArrayOrdinalMap;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FastBlobReader {
    private final FastBlobStateEngine stateEngine;
    private FastBlobHeaderReader headerReader;
    private FastBlobReaderEventHandler eventHandler = null;

    public FastBlobReader(FastBlobStateEngine stateEngine) {
        this.stateEngine = stateEngine;
        this.headerReader = new ZenoFastBlobHeaderReader();
    }

    public void setFastBlobHeaderReader(FastBlobHeaderReader headerReader) {
        this.headerReader = headerReader;
    }

    public void setEventHandler(FastBlobReaderEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void readSnapshot(InputStream is) throws IOException {
        FastBlobHeader header = this.readHeader(is);
        StreamingByteData byteData = this.getStreamingByteData(is, header.getDeserializationBufferSizeHint());
        DataInputStream dis = new DataInputStream(byteData);
        int numTypes = header.getNumberOfTypes();
        if (this.stateEngine.getLatestVersion() == null) {
            this.readSnapshotTypes(byteData, dis, numTypes);
        } else {
            this.readSnapshotTypesDoubleSnapshotRefresh(byteData, dis, numTypes);
        }
        this.stateEngine.setLatestVersion(header.getVersion());
    }

    private void readSnapshotTypes(StreamingByteData byteData, DataInputStream dis, int numTypes) throws IOException {
        for (int i = 0; i < numTypes; ++i) {
            dis.read();
            FastBlobSchema schema = FastBlobSchema.readFrom(dis);
            this.readTypeStateObjects(byteData, schema);
        }
    }

    private void readSnapshotTypesDoubleSnapshotRefresh(StreamingByteData byteData, DataInputStream dis, int numTypes) throws IOException {
        ByteArrayOrdinalMap serializedRepresentationMap = new ByteArrayOrdinalMap();
        this.stateEngine.prepareForDoubleSnapshotRefresh();
        for (int i = 0; i < numTypes; ++i) {
            dis.read();
            FastBlobSchema schema = FastBlobSchema.readFrom(dis);
            this.readTypeStateObjectsDoubleSnapshotRefresh(byteData, schema, serializedRepresentationMap);
            serializedRepresentationMap.clear();
        }
        this.stateEngine.cleanUpAfterDoubleSnapshotRefresh();
    }

    public void readDelta(InputStream is) throws IOException {
        FastBlobHeader header = this.readHeader(is);
        StreamingByteData byteData = this.getStreamingByteData(is, header.getDeserializationBufferSizeHint());
        DataInputStream dis = new DataInputStream(byteData);
        int numTypes = header.getNumberOfTypes();
        for (int i = 0; i < numTypes; ++i) {
            dis.read();
            FastBlobSchema schema = FastBlobSchema.readFrom(dis);
            this.readTypeStateRemovals(byteData, schema);
            this.readTypeStateObjects(byteData, schema);
        }
        this.stateEngine.setLatestVersion(header.getVersion());
    }

    private FastBlobHeader readHeader(InputStream is) throws IOException {
        FastBlobHeader header = this.headerReader.readHeader(is);
        this.stateEngine.addHeaderTags(header.getHeaderTags());
        return header;
    }

    private StreamingByteData getStreamingByteData(InputStream is, int deserializationBufferSizeHint) throws IOException {
        StreamingByteData byteData = new StreamingByteData(is, deserializationBufferSizeHint);
        return byteData;
    }

    private void readTypeStateRemovals(StreamingByteData byteData, FastBlobSchema schema) throws IOException {
        FastBlobTypeDeserializationState typeDeserializationState = this.stateEngine.getTypeDeserializationState(schema.getName());
        int numRemovals = VarInt.readVInt(byteData);
        int currentRemoval = 0;
        if (numRemovals != 0 && this.eventHandler != null) {
            this.eventHandler.removedObjects(schema.getName(), numRemovals);
        }
        for (int i = 0; i < numRemovals; ++i) {
            currentRemoval += VarInt.readVInt(byteData);
            if (typeDeserializationState == null) continue;
            typeDeserializationState.remove(currentRemoval);
        }
    }

    private void readTypeStateObjects(StreamingByteData byteData, FastBlobSchema schema) throws IOException {
        FastBlobDeserializationRecord rec = new FastBlobDeserializationRecord(schema, byteData);
        FastBlobTypeDeserializationState typeDeserializationState = this.stateEngine.getTypeDeserializationState(schema.getName());
        int numObjects = VarInt.readVInt(byteData);
        if (numObjects != 0 && this.eventHandler != null) {
            this.eventHandler.addedObjects(schema.getName(), numObjects);
        }
        int currentOrdinal = 0;
        for (int j = 0; j < numObjects; ++j) {
            int currentOrdinalDelta = VarInt.readVInt(byteData);
            currentOrdinal += currentOrdinalDelta;
            int objectSize = rec.position(byteData.currentStreamPosition());
            byteData.incrementStreamPosition(objectSize);
            if (typeDeserializationState == null) continue;
            typeDeserializationState.add(currentOrdinal, rec);
        }
    }

    private <T> void readTypeStateObjectsDoubleSnapshotRefresh(StreamingByteData byteData, FastBlobSchema schema, ByteArrayOrdinalMap map) throws IOException {
        FastBlobHeapFriendlyClientFrameworkSerializer frameworkSerializer = (FastBlobHeapFriendlyClientFrameworkSerializer)this.stateEngine.getFrameworkSerializer();
        FastBlobDeserializationRecord rec = new FastBlobDeserializationRecord(schema, byteData);
        FastBlobTypeDeserializationState typeDeserializationState = this.stateEngine.getTypeDeserializationState(schema.getName());
        FastBlobSerializationRecord serializationRecord = null;
        ByteDataBuffer deserializedRecordBuffer = null;
        int numObjects = VarInt.readVInt(byteData);
        int numObjectsReused = 0;
        int numFlawedSerializationIntegrity = 0;
        if (numObjects != 0 && this.eventHandler != null) {
            this.eventHandler.addedObjects(schema.getName(), numObjects);
        }
        if (typeDeserializationState != null) {
            serializationRecord = new FastBlobSerializationRecord(typeDeserializationState.getSchema());
            frameworkSerializer.setCheckSerializationIntegrity(false);
            deserializedRecordBuffer = new ByteDataBuffer();
            typeDeserializationState.populateByteArrayOrdinalMap(map);
            frameworkSerializer.setCheckSerializationIntegrity(true);
        }
        int currentOrdinal = 0;
        for (int j = 0; j < numObjects; ++j) {
            int currentOrdinalDelta = VarInt.readVInt(byteData);
            currentOrdinal += currentOrdinalDelta;
            int recordSize = rec.position(byteData.currentStreamPosition());
            if (typeDeserializationState != null) {
                NFTypeSerializer serializer = typeDeserializationState.getSerializer();
                Object deserializedObject = serializer.deserialize(rec);
                serializer.serialize(deserializedObject, serializationRecord);
                serializationRecord.writeDataTo(deserializedRecordBuffer);
                int previousOrdinal = map.get(deserializedRecordBuffer);
                serializationRecord.reset();
                deserializedRecordBuffer.reset();
                if (previousOrdinal != -1 && !frameworkSerializer.isSerializationIntegrityFlawed()) {
                    typeDeserializationState.copyPrevious(currentOrdinal, previousOrdinal);
                    ++numObjectsReused;
                } else {
                    if (frameworkSerializer.isSerializationIntegrityFlawed()) {
                        ++numFlawedSerializationIntegrity;
                    }
                    typeDeserializationState.add(currentOrdinal, rec);
                }
                frameworkSerializer.clearSerializationIntegrityFlawedFlag();
            }
            byteData.incrementStreamPosition(recordSize);
        }
        if (typeDeserializationState != null) {
            typeDeserializationState.clearPreviousObjects();
            typeDeserializationState.createIdentityOrdinalMap();
        }
        if (this.eventHandler != null) {
            if (numObjects != 0) {
                this.eventHandler.reusedObjects(schema.getName(), numObjectsReused);
            }
            if (numFlawedSerializationIntegrity != 0) {
                this.eventHandler.objectsFailedReserialization(schema.getName(), numFlawedSerializationIntegrity);
            }
        }
    }
}

