/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.io;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.io.FastBlobHeader;
import com.netflix.zeno.fastblob.io.FastBlobHeaderWriter;
import com.netflix.zeno.fastblob.io.ZenoFastBlobHeaderWriter;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.fastblob.state.FastBlobTypeSerializationState;
import com.netflix.zeno.fastblob.state.ThreadSafeBitSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastBlobWriter {
    private final FastBlobStateEngine stateEngine;
    private final int imageIndex;
    private FastBlobHeaderWriter headerWriter;

    public FastBlobWriter(FastBlobStateEngine stateEngine) {
        this(stateEngine, 0);
    }

    public FastBlobWriter(FastBlobStateEngine stateEngine, int imageIndex) {
        this(stateEngine, imageIndex, new ZenoFastBlobHeaderWriter());
    }

    public void setFastBlobHeaderWriter(FastBlobHeaderWriter headerWriter) {
        this.headerWriter = headerWriter;
    }

    public FastBlobWriter(FastBlobStateEngine stateEngine, int imageIndex, FastBlobHeaderWriter headerWriter) {
        this.stateEngine = stateEngine;
        this.imageIndex = imageIndex;
        this.headerWriter = headerWriter;
    }

    public void writeSnapshot(OutputStream os) throws Exception {
        this.writeSnapshot(new DataOutputStream(os));
    }

    public void writeSnapshot(DataOutputStream os) throws IOException {
        this.writeHeader(os);
        for (FastBlobTypeSerializationState<?> typeState : this.stateEngine.getOrderedSerializationStates()) {
            if (!typeState.isReadyForWriting()) {
                throw new RuntimeException("This state engine is not ready for writing! Have you remembered to call stateEngine.prepareForWrite()?");
            }
            os.write(0);
            typeState.getSchema().writeTo(os);
            ThreadSafeBitSet imageMembershipBitSet = typeState.getImageMembershipBitSet(this.imageIndex);
            this.serializeTypeStateObjects(os, typeState, imageMembershipBitSet);
        }
    }

    public void writeNonImageSpecificSnapshot(DataOutputStream os) throws IOException {
        this.writeHeader(os);
        for (FastBlobTypeSerializationState<?> typeState : this.stateEngine.getOrderedSerializationStates()) {
            if (!typeState.isReadyForWriting()) {
                throw new RuntimeException("This state engine is not ready for writing! Have you remembered to call stateEngine.prepareForWrite()?");
            }
            FastBlobTypeDeserializationState typeDeserializationState = this.stateEngine.getTypeDeserializationState(typeState.getSchema().getName());
            os.write(0);
            typeState.getSchema().writeTo(os);
            this.serializeTypeStateObjects(os, typeState, typeDeserializationState);
        }
    }

    public void writeDelta(OutputStream os) throws IOException {
        this.writeDelta(new DataOutputStream(os));
    }

    public void writeDelta(DataOutputStream os) throws IOException {
        this.writeHeader(os);
        for (FastBlobTypeSerializationState<?> typeState : this.stateEngine.getOrderedSerializationStates()) {
            if (!typeState.isReadyForWriting()) {
                throw new RuntimeException("This state engine is not ready for writing! Have you remembered to call stateEngine.prepareForWrite()?");
            }
            os.write(0);
            typeState.getSchema().writeTo(os);
            ThreadSafeBitSet currentImageMembershipBitSet = typeState.getImageMembershipBitSet(this.imageIndex);
            ThreadSafeBitSet previousImageMembershipBitSet = typeState.getPreviousCycleImageMembershipBitSet(this.imageIndex);
            this.serializeDelta(os, typeState, currentImageMembershipBitSet, previousImageMembershipBitSet);
        }
    }

    public void writeReverseDelta(OutputStream os, String previousVersion) throws IOException {
        this.writeReverseDelta(new DataOutputStream(os), previousVersion);
    }

    public void writeReverseDelta(DataOutputStream os, String previousVersion) throws IOException {
        this.writeHeader(os, previousVersion);
        for (FastBlobTypeSerializationState<?> typeState : this.stateEngine.getOrderedSerializationStates()) {
            if (!typeState.isReadyForWriting()) {
                throw new RuntimeException("This state engine is not ready for writing! Have you remembered to call stateEngine.prepareForWrite()?");
            }
            if (typeState.getPreviousStateSchema() == null) continue;
            os.write(0);
            typeState.getPreviousStateSchema().writeTo(os);
            ThreadSafeBitSet currentImageMembershipBitSet = typeState.getImageMembershipBitSet(this.imageIndex);
            ThreadSafeBitSet previousImageMembershipBitSet = typeState.getPreviousCycleImageMembershipBitSet(this.imageIndex);
            this.serializeDelta(os, typeState, previousImageMembershipBitSet, currentImageMembershipBitSet);
        }
    }

    private void serializeDelta(DataOutputStream os, FastBlobTypeSerializationState<?> typeState, ThreadSafeBitSet currentStateOrdinals, ThreadSafeBitSet prevStateOrdinals) throws IOException {
        ThreadSafeBitSet removedTypeStateObjectsBitSet = prevStateOrdinals.andNot(currentStateOrdinals);
        this.serializeTypeStateRemovals(os, removedTypeStateObjectsBitSet);
        ThreadSafeBitSet addedTypeStateObjectsBitSet = currentStateOrdinals.andNot(prevStateOrdinals);
        this.serializeTypeStateObjects(os, typeState, addedTypeStateObjectsBitSet);
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        String version = this.stateEngine.getLatestVersion() != null ? this.stateEngine.getLatestVersion() : "";
        this.writeHeader(os, version);
    }

    private void writeHeader(DataOutputStream os, String version) throws IOException {
        FastBlobHeader header = new FastBlobHeader();
        header.setVersion(version);
        header.setHeaderTags(this.stateEngine.getHeaderTags());
        int deserializationBufferSizeHint = 32 - Integer.numberOfLeadingZeros(this.stateEngine.getMaxSingleObjectLength() - 1);
        header.setDeserializationBufferSizeHint(deserializationBufferSizeHint);
        header.setNumberOfTypes(this.stateEngine.getOrderedSerializationStates().size());
        this.headerWriter.writeHeader(header, this.stateEngine, os);
    }

    private void serializeTypeStateObjects(DataOutputStream os, FastBlobTypeSerializationState<?> typeState, ThreadSafeBitSet includeOrdinals) throws IOException {
        int currentBitSetCapacity = includeOrdinals.currentCapacity();
        int currentOrdinal = 0;
        VarInt.writeVInt(os, includeOrdinals.cardinality());
        for (int i = 0; i < currentBitSetCapacity; ++i) {
            if (!includeOrdinals.get(i)) continue;
            VarInt.writeVInt(os, i - currentOrdinal);
            currentOrdinal = i;
            typeState.writeObjectTo(os, i);
        }
    }

    private void serializeTypeStateObjects(DataOutputStream os, FastBlobTypeSerializationState<?> typeState, FastBlobTypeDeserializationState<?> typeDeserializationState) throws IOException {
        VarInt.writeVInt(os, typeDeserializationState.countObjects());
        int currentOrdinal = 0;
        for (int i = 0; i <= typeDeserializationState.maxOrdinal(); ++i) {
            Object obj = typeDeserializationState.get(i);
            if (obj == null) continue;
            VarInt.writeVInt(os, i - currentOrdinal);
            currentOrdinal = i;
            typeState.writeObjectTo(os, i);
        }
    }

    private void serializeTypeStateRemovals(DataOutputStream os, ThreadSafeBitSet removals) throws IOException {
        int bitSetCapacity = removals.currentCapacity();
        int currentRemoval = 0;
        VarInt.writeVInt(os, removals.cardinality());
        for (int i = 0; i < bitSetCapacity; ++i) {
            if (!removals.get(i)) continue;
            VarInt.writeVInt(os, i - currentRemoval);
            currentRemoval = i;
        }
    }
}

