/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.io;

import com.netflix.zeno.fastblob.io.FastBlobHeader;
import com.netflix.zeno.fastblob.io.FastBlobHeaderReader;
import com.netflix.zeno.fastblob.io.FastBlobMalformedDataException;
import com.netflix.zeno.fastblob.record.VarInt;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ZenoFastBlobHeaderReader
implements FastBlobHeaderReader {
    @Override
    public FastBlobHeader readHeader(InputStream is) throws IOException, FastBlobMalformedDataException {
        FastBlobHeader header = new FastBlobHeader();
        DataInputStream dis = new DataInputStream(is);
        int headerVersion = dis.readInt();
        if (headerVersion != 1029) {
            throw new FastBlobMalformedDataException("The FastBlob you are trying to read is incompatible.  The expected FastBlob version was 1029 but the actual version was " + headerVersion);
        }
        String latestVersion = dis.readUTF();
        header.setVersion(latestVersion);
        Map<String, String> headerTags = this.readHeaderTags(dis);
        header.setHeaderTags(headerTags);
        int deserializationBufferSizeHint = is.read();
        header.setDeserializationBufferSizeHint(deserializationBufferSizeHint);
        dis.read();
        int numTypes = VarInt.readVInt(is);
        header.setNumberOfTypes(numTypes);
        return header;
    }

    private Map<String, String> readHeaderTags(DataInputStream dis) throws IOException {
        int numHeaderTags = dis.readShort();
        HashMap<String, String> headerTags = new HashMap<String, String>();
        for (int i = 0; i < numHeaderTags; ++i) {
            headerTags.put(dis.readUTF(), dis.readUTF());
        }
        return headerTags;
    }
}

