/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.SegmentedByteArray;

public class ByteDataBuffer {
    private final SegmentedByteArray buf;
    private long position;

    public ByteDataBuffer() {
        this(256);
    }

    public ByteDataBuffer(int startSize) {
        int log2OfSize = 32 - Integer.numberOfLeadingZeros(startSize - 1);
        this.buf = new SegmentedByteArray(log2OfSize - 1);
    }

    public void write(byte b) {
        this.buf.set(this.position++, b);
    }

    public void reset() {
        this.position = 0L;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long length() {
        return this.position;
    }

    public void copyTo(ByteDataBuffer other) {
        other.buf.copy(this.buf, 0L, other.position, this.position);
        other.position += this.position;
    }

    public void copyFrom(ByteDataBuffer other) {
        this.buf.copy(other.buf, 0L, this.position, other.position);
        this.position += other.position;
    }

    public void copyFrom(ByteData data, long startPosition, int length) {
        this.buf.copy(data, startPosition, this.position, (long)length);
        this.position += (long)length;
    }

    public void copyFrom(SegmentedByteArray data, long startPosition, int length) {
        this.buf.copy(data, startPosition, this.position, (long)length);
        this.position += (long)length;
    }

    public byte get(long index) {
        return this.buf.get(index);
    }

    public SegmentedByteArray getUnderlyingArray() {
        return this.buf;
    }
}

