/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;

public class FastBlobDeserializationRecord
extends NFDeserializationRecord {
    private final ByteData byteData;
    private final long[] fieldPointers;

    public FastBlobDeserializationRecord(FastBlobSchema schema, ByteData byteData) {
        super(schema);
        this.fieldPointers = new long[schema.numFields()];
        this.byteData = byteData;
    }

    public long position() {
        return this.fieldPointers[0];
    }

    public int position(long objectBeginOffset) {
        long currentPosition = objectBeginOffset;
        for (int i = 0; i < this.fieldPointers.length; ++i) {
            this.fieldPointers[i] = currentPosition;
            FastBlobSchema.FieldType type = this.getSchema().getFieldType(i);
            currentPosition += (long)this.fieldLength(currentPosition, type);
        }
        return (int)(currentPosition - objectBeginOffset);
    }

    public ByteData getByteData() {
        return this.byteData;
    }

    public long getPosition(String fieldName) {
        int fieldPosition = this.getSchema().getPosition(fieldName);
        if (fieldPosition == -1) {
            return -1L;
        }
        return this.fieldPointers[fieldPosition];
    }

    public int getFieldLength(String fieldName) {
        int fieldPosition = this.getSchema().getPosition(fieldName);
        FastBlobSchema.FieldType fieldType = this.getSchema().getFieldType(fieldPosition);
        return this.fieldLength(this.fieldPointers[fieldPosition], fieldType);
    }

    private int fieldLength(long currentPosition, FastBlobSchema.FieldType type) {
        if (type.startsWithVarIntEncodedLength()) {
            if (VarInt.readVNull(this.byteData, currentPosition)) {
                return 1;
            }
            int fieldLength = VarInt.readVInt(this.byteData, currentPosition);
            return VarInt.sizeOfVInt(fieldLength) + fieldLength;
        }
        if (type.getFixedLength() != -1) {
            return type.getFixedLength();
        }
        if (VarInt.readVNull(this.byteData, currentPosition)) {
            return 1;
        }
        long value = VarInt.readVLong(this.byteData, currentPosition);
        return VarInt.sizeOfVLong(value);
    }
}

