/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.FastBlobFrameworkSerializer;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFSerializationRecord;

public class FastBlobSerializationRecord
extends NFSerializationRecord {
    private final ByteDataBuffer[] fieldData;
    private final boolean[] isNonNull;
    private long imageMembershipsFlags;

    public FastBlobSerializationRecord(FastBlobSchema schema) {
        this.fieldData = new ByteDataBuffer[schema.numFields()];
        this.isNonNull = new boolean[schema.numFields()];
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.fieldData[i] = new ByteDataBuffer(32);
        }
        this.setSchema(schema);
    }

    public ByteDataBuffer getFieldBuffer(String field) {
        int fieldPosition = this.getSchema().getPosition(field);
        return this.getFieldBuffer(fieldPosition);
    }

    public ByteDataBuffer getFieldBuffer(int fieldPosition) {
        this.isNonNull[fieldPosition] = true;
        this.fieldData[fieldPosition].reset();
        return this.fieldData[fieldPosition];
    }

    public void writeDataTo(ByteDataBuffer buf) {
        for (int i = 0; i < this.fieldData.length; ++i) {
            if (this.isNonNull[i]) {
                if (this.getSchema().getFieldType(i).startsWithVarIntEncodedLength()) {
                    VarInt.writeVInt(buf, (int)this.fieldData[i].length());
                }
                this.fieldData[i].copyTo(buf);
                continue;
            }
            if (this.getSchema().getFieldType(i) == FastBlobSchema.FieldType.FLOAT) {
                FastBlobFrameworkSerializer.writeNullFloat(buf);
                continue;
            }
            if (this.getSchema().getFieldType(i) == FastBlobSchema.FieldType.DOUBLE) {
                FastBlobFrameworkSerializer.writeNullDouble(buf);
                continue;
            }
            VarInt.writeVNull(buf);
        }
    }

    public void reset() {
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.isNonNull[i] = false;
        }
    }

    public void setImageMembershipsFlags(long imageMembershipsFlags) {
        this.imageMembershipsFlags = imageMembershipsFlags;
    }

    public long getImageMembershipsFlags() {
        return this.imageMembershipsFlags;
    }
}

