/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.record.ByteData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class SegmentedByteArray
implements ByteData {
    private byte[][] segments = new byte[2][];
    private final int log2OfSegmentSize;
    private final int bitmask;

    public SegmentedByteArray(int log2OfSegmentSize) {
        this.log2OfSegmentSize = log2OfSegmentSize;
        this.bitmask = (1 << log2OfSegmentSize) - 1;
    }

    public void set(long index, byte value) {
        int segmentIndex = (int)(index >> this.log2OfSegmentSize);
        this.ensureCapacity(segmentIndex);
        this.segments[segmentIndex][(int)(index & (long)this.bitmask)] = value;
    }

    @Override
    public byte get(long index) {
        return this.segments[(int)(index >>> this.log2OfSegmentSize)][(int)(index & (long)this.bitmask)];
    }

    public void copy(ByteData src, long srcPos, long destPos, long length) {
        for (long i = 0L; i < length; ++i) {
            this.set(destPos++, src.get(srcPos++));
        }
    }

    public void copy(SegmentedByteArray src, long srcPos, long destPos, long length) {
        int segmentLength = 1 << this.log2OfSegmentSize;
        int currentSegment = (int)(destPos >>> this.log2OfSegmentSize);
        int segmentStartPos = (int)(destPos & (long)this.bitmask);
        int remainingBytesInSegment = segmentLength - segmentStartPos;
        while (length > 0L) {
            int bytesToCopyFromSegment = (int)Math.min((long)remainingBytesInSegment, length);
            this.ensureCapacity(currentSegment);
            int copiedBytes = src.copy(srcPos, this.segments[currentSegment], segmentStartPos, bytesToCopyFromSegment);
            srcPos += (long)copiedBytes;
            length -= (long)copiedBytes;
            segmentStartPos = 0;
            remainingBytesInSegment = segmentLength;
            ++currentSegment;
        }
    }

    public int copy(long srcPos, byte[] data, int destPos, int length) {
        int segmentSize = 1 << this.log2OfSegmentSize;
        int remainingBytesInSegment = (int)((long)segmentSize - (srcPos & (long)this.bitmask));
        int dataPosition = destPos;
        while (length > 0) {
            byte[] segment = this.segments[(int)(srcPos >>> this.log2OfSegmentSize)];
            int bytesToCopyFromSegment = Math.min(remainingBytesInSegment, length);
            System.arraycopy(segment, (int)(srcPos & (long)this.bitmask), data, dataPosition, bytesToCopyFromSegment);
            dataPosition += bytesToCopyFromSegment;
            remainingBytesInSegment = segmentSize - (int)((srcPos += (long)bytesToCopyFromSegment) & (long)this.bitmask);
            length -= bytesToCopyFromSegment;
        }
        return dataPosition - destPos;
    }

    public void readFrom(RandomAccessFile file, long pointer, int length) throws IOException {
        file.seek(pointer);
        int segmentSize = 1 << this.log2OfSegmentSize;
        int segment = 0;
        while (length > 0) {
            int bytesCopied;
            this.ensureCapacity(segment);
            int bytesToCopy = Math.min(segmentSize, length);
            for (bytesCopied = 0; bytesCopied < bytesToCopy; bytesCopied += file.read(this.segments[segment], bytesCopied, bytesToCopy - bytesCopied)) {
            }
            ++segment;
            length -= bytesCopied;
        }
    }

    public void writeTo(OutputStream os, long startPosition, long len) throws IOException {
        long bytesToCopyFromSegment;
        int segmentSize = 1 << this.log2OfSegmentSize;
        int remainingBytesInSegment = segmentSize - (int)(startPosition & (long)this.bitmask);
        for (long remainingBytesInCopy = len; remainingBytesInCopy > 0L; remainingBytesInCopy -= bytesToCopyFromSegment) {
            bytesToCopyFromSegment = Math.min((long)remainingBytesInSegment, remainingBytesInCopy);
            os.write(this.segments[(int)(startPosition >>> this.log2OfSegmentSize)], (int)(startPosition & (long)this.bitmask), (int)bytesToCopyFromSegment);
            remainingBytesInSegment = segmentSize - (int)((startPosition += bytesToCopyFromSegment) & (long)this.bitmask);
        }
    }

    private void ensureCapacity(int segmentIndex) {
        while (segmentIndex >= this.segments.length) {
            this.segments = (byte[][])Arrays.copyOf(this.segments, this.segments.length * 3 / 2);
        }
        if (this.segments[segmentIndex] == null) {
            this.segments[segmentIndex] = new byte[1 << this.log2OfSegmentSize];
        }
    }
}

