/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;

public class SegmentedByteArrayHasher {
    private static final int SEED = -357227335;

    public static int hashCode(ByteDataBuffer data) {
        return SegmentedByteArrayHasher.hashCode(data.getUnderlyingArray(), 0L, (int)data.length());
    }

    public static int hashCode(ByteData data, long offset, int len) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = -357227335;
        long roundedEnd = offset + ((long)len & 0xFFFFFFFFFFFFFFFCL);
        for (long i = offset; i < roundedEnd; i += 4L) {
            int k1 = data.get(i) & 0xFF | (data.get(i + 1L) & 0xFF) << 8 | (data.get(i + 2L) & 0xFF) << 16 | data.get(i + 3L) << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 = (data.get(roundedEnd + 2L) & 0xFF) << 16;
            }
            case 2: {
                k1 |= (data.get(roundedEnd + 1L) & 0xFF) << 8;
            }
            case 1: {
                k1 |= data.get(roundedEnd) & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

