/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record;

import com.netflix.zeno.fastblob.record.ByteData;
import java.io.IOException;
import java.io.InputStream;

public class StreamingByteData
extends InputStream
implements ByteData {
    private final InputStream underlyingStream;
    private final int bufferSegmentLength;
    private final int log2OfBufferSegmentLength;
    private final int bufferSegmentLengthMask;
    private long bufferStartPosition;
    private final byte[][] buf;
    private long eofPosition = Long.MAX_VALUE;
    private long currentStreamPosition;

    public StreamingByteData(InputStream in, int log2OfBufferSegmentLength) {
        this.underlyingStream = in;
        this.log2OfBufferSegmentLength = log2OfBufferSegmentLength;
        this.bufferSegmentLength = 1 << log2OfBufferSegmentLength;
        this.bufferSegmentLengthMask = this.bufferSegmentLength - 1;
        this.buf = new byte[4][];
        for (int i = 0; i < 4; ++i) {
            this.buf[i] = new byte[this.bufferSegmentLength];
            if (this.eofPosition != Long.MAX_VALUE) continue;
            this.fillArray(this.buf[i], this.bufferSegmentLength * i);
        }
    }

    @Override
    public byte get(long position) {
        if ((position -= this.bufferStartPosition) >= (long)(this.bufferSegmentLength * 3)) {
            this.fillNewBuffer();
            position -= (long)this.bufferSegmentLength;
        }
        if ((int)(position >>> this.log2OfBufferSegmentLength) < 0 || (int)(position & (long)this.bufferSegmentLengthMask) < 0) {
            System.out.println("found a bug");
        }
        return this.buf[(int)(position >>> this.log2OfBufferSegmentLength)][(int)(position & (long)this.bufferSegmentLengthMask)];
    }

    @Override
    public int read() throws IOException {
        if (this.currentStreamPosition >= this.eofPosition) {
            return -1;
        }
        return this.get(this.currentStreamPosition++);
    }

    public long currentStreamPosition() {
        return this.currentStreamPosition;
    }

    public void incrementStreamPosition(int incrementBy) {
        this.currentStreamPosition += (long)incrementBy;
    }

    @Override
    public void close() throws IOException {
        this.underlyingStream.close();
    }

    private void fillNewBuffer() {
        byte[] temp = this.buf[0];
        this.buf[0] = this.buf[1];
        this.buf[1] = this.buf[2];
        this.buf[2] = this.buf[3];
        this.buf[3] = temp;
        this.bufferStartPosition += (long)this.bufferSegmentLength;
        if (this.eofPosition == Long.MAX_VALUE) {
            this.fillArray(this.buf[3], this.bufferStartPosition + (long)(this.bufferSegmentLength * 3));
        }
    }

    private void fillArray(byte[] arr, long segmentStartByte) {
        try {
            int count;
            for (int n = 0; n < arr.length; n += count) {
                count = this.underlyingStream.read(arr, n, arr.length - n);
                if (count >= 0) continue;
                this.eofPosition = segmentStartByte + (long)n;
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream", e);
        }
    }
}

