/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.record.schema;

import com.netflix.zeno.fastblob.record.schema.FieldDefinition;
import com.netflix.zeno.fastblob.record.schema.MapFieldDefinition;
import com.netflix.zeno.fastblob.record.schema.TypedFieldDefinition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class FastBlobSchema {
    private final String schemaName;
    private final int[] hashedPositionArray;
    private final String[] fieldNames;
    private final FieldDefinition[] fieldDefinitions;
    private int size;

    public FastBlobSchema(String schemaName, int numFields) {
        this.schemaName = schemaName;
        this.hashedPositionArray = new int[1 << 32 - Integer.numberOfLeadingZeros(numFields * 10 / 7)];
        this.fieldNames = new String[numFields];
        this.fieldDefinitions = new FieldDefinition[numFields];
        Arrays.fill(this.hashedPositionArray, -1);
    }

    public String getName() {
        return this.schemaName;
    }

    @Deprecated
    public int addField(String fieldName, FieldType fieldType) {
        return this.addField(fieldName, new FieldDefinition(fieldType));
    }

    public int addField(String fieldName, FieldDefinition fieldDefinition) {
        this.fieldNames[this.size] = fieldName;
        this.fieldDefinitions[this.size] = fieldDefinition;
        this.hashPositionIntoArray(this.size);
        return this.size++;
    }

    public int getPosition(String fieldName) {
        int hash = this.hashInt(fieldName.hashCode());
        int bucket = hash % this.hashedPositionArray.length;
        int position = this.hashedPositionArray[bucket];
        while (position != -1) {
            if (this.fieldNames[position].equals(fieldName)) {
                return position;
            }
            bucket = (bucket + 1) % this.hashedPositionArray.length;
            position = this.hashedPositionArray[bucket];
        }
        return -1;
    }

    public String getFieldName(int fieldPosition) {
        return this.fieldNames[fieldPosition];
    }

    public FieldType getFieldType(String fieldName) {
        int position = this.getPosition(fieldName);
        if (position == -1) {
            throw new IllegalArgumentException("Field name " + fieldName + " does not exist in schema " + this.schemaName);
        }
        return this.fieldDefinitions[position].getFieldType();
    }

    public FieldType getFieldType(int fieldPosition) {
        return this.fieldDefinitions[fieldPosition].getFieldType();
    }

    public FieldDefinition getFieldDefinition(String fieldName) {
        int position = this.getPosition(fieldName);
        if (position == -1) {
            throw new IllegalArgumentException("Field name " + fieldName + " does not exist in schema " + this.schemaName);
        }
        return this.getFieldDefinition(position);
    }

    public FieldDefinition getFieldDefinition(int fieldPosition) {
        return this.fieldDefinitions[fieldPosition];
    }

    public String getObjectType(String fieldName) {
        int position = this.getPosition(fieldName);
        if (position == -1) {
            throw new IllegalArgumentException("Field name " + fieldName + " does not exist in schema " + this.schemaName);
        }
        return this.getObjectType(position);
    }

    public String getObjectType(int fieldPosition) {
        if (this.fieldDefinitions[fieldPosition] instanceof TypedFieldDefinition) {
            return ((TypedFieldDefinition)this.fieldDefinitions[fieldPosition]).getSubType();
        }
        return null;
    }

    public int numFields() {
        return this.size;
    }

    private void hashPositionIntoArray(int ordinal) {
        int hash = this.hashInt(this.fieldNames[ordinal].hashCode());
        int bucket = hash % this.hashedPositionArray.length;
        while (this.hashedPositionArray[bucket] != -1) {
            bucket = (bucket + 1) % this.hashedPositionArray.length;
        }
        this.hashedPositionArray[bucket] = ordinal;
    }

    private int hashInt(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key & Integer.MAX_VALUE;
    }

    public boolean equals(Object other) {
        if (other instanceof FastBlobSchema) {
            FastBlobSchema otherSchema = (FastBlobSchema)other;
            if (otherSchema.schemaName.equals(this.schemaName) && otherSchema.size == this.size) {
                for (int i = 0; i < otherSchema.size; ++i) {
                    if (!otherSchema.getFieldName(i).equals(this.getFieldName(i))) {
                        return false;
                    }
                    if (otherSchema.getFieldDefinition(i).equals(this.getFieldDefinition(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.schemaName);
        dos.writeShort(this.size);
        for (int i = 0; i < this.size; ++i) {
            dos.writeUTF(this.fieldNames[i]);
            this.writeFieldDefinition(dos, this.fieldDefinitions[i]);
        }
    }

    private void writeFieldDefinition(DataOutputStream dos, FieldDefinition def) throws IOException {
        FieldType fieldType = def.getFieldType();
        dos.writeUTF(fieldType.name());
        if (fieldType == FieldType.OBJECT || fieldType == FieldType.LIST || fieldType == FieldType.SET) {
            if (def instanceof TypedFieldDefinition) {
                dos.writeUTF(((TypedFieldDefinition)def).getSubType());
            } else {
                dos.writeUTF("");
            }
        } else if (fieldType == FieldType.MAP) {
            if (def instanceof MapFieldDefinition) {
                MapFieldDefinition mfd = (MapFieldDefinition)def;
                dos.writeUTF(mfd.getKeyType());
                dos.writeUTF(mfd.getValueType());
            } else {
                dos.writeUTF("");
                dos.writeUTF("");
            }
        }
    }

    public static FastBlobSchema readFrom(DataInputStream dis) throws IOException {
        String name = dis.readUTF();
        int size = dis.readShort();
        FastBlobSchema schema = new FastBlobSchema(name, size);
        for (int i = 0; i < size; ++i) {
            String fieldName = dis.readUTF();
            FieldDefinition def = FastBlobSchema.readFieldDefinition(dis);
            schema.addField(fieldName, def);
        }
        return schema;
    }

    private static FieldDefinition readFieldDefinition(DataInputStream dis) throws IOException {
        FieldType fieldType = Enum.valueOf(FieldType.class, dis.readUTF());
        if (fieldType == FieldType.OBJECT || fieldType == FieldType.LIST || fieldType == FieldType.SET) {
            String subType = dis.readUTF();
            if (!subType.isEmpty()) {
                return new TypedFieldDefinition(fieldType, subType);
            }
        } else if (fieldType == FieldType.MAP) {
            String keyType = dis.readUTF();
            String valueType = dis.readUTF();
            if (!keyType.isEmpty()) {
                return new MapFieldDefinition(keyType, valueType);
            }
        }
        return new FieldDefinition(fieldType);
    }

    public static enum FieldType {
        OBJECT(-1, false),
        BOOLEAN(1, false),
        INT(-1, false),
        LONG(-1, false),
        FLOAT(4, false),
        DOUBLE(8, false),
        STRING(-1, true),
        BYTES(-1, true),
        LIST(-1, true),
        SET(-1, true),
        COLLECTION(-1, true),
        MAP(-1, true);

        private final int fixedLength;
        private final boolean varIntEncodesLength;

        private FieldType(int fixedLength, boolean varIntEncodesLength) {
            this.fixedLength = fixedLength;
            this.varIntEncodesLength = varIntEncodesLength;
        }

        public int getFixedLength() {
            return this.fixedLength;
        }

        public boolean startsWithVarIntEncodedLength() {
            return this.varIntEncodesLength;
        }
    }
}

