/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import com.netflix.zeno.fastblob.FastBlobImageUtils;
import com.netflix.zeno.fastblob.OrdinalMapping;
import com.netflix.zeno.fastblob.StateOrdinalMapping;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobDeserializationRecord;
import com.netflix.zeno.fastblob.record.SegmentedByteArray;
import com.netflix.zeno.fastblob.record.SegmentedByteArrayHasher;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.fastblob.state.FastBlobTypeSerializationState;
import com.netflix.zeno.fastblob.state.FreeOrdinalTracker;
import com.netflix.zeno.fastblob.state.OrdinalRemapper;
import com.netflix.zeno.fastblob.state.ThreadSafeBitSet;
import com.netflix.zeno.util.SimultaneousExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;

public class ByteArrayOrdinalMap {
    private static final long EMPTY_BUCKET_VALUE = -1L;
    private AtomicLongArray pointersAndOrdinals;
    private final ByteDataBuffer byteData;
    private final FreeOrdinalTracker freeOrdinalTracker;
    private int size;
    private int sizeBeforeGrow;
    private long[] pointersByOrdinal;

    public ByteArrayOrdinalMap() {
        this(262144);
    }

    public ByteArrayOrdinalMap(int bufferSize) {
        this.freeOrdinalTracker = new FreeOrdinalTracker();
        this.byteData = new ByteDataBuffer(bufferSize);
        this.pointersAndOrdinals = this.emptyKeyArray(256);
        this.sizeBeforeGrow = 179;
        this.size = 0;
    }

    private ByteArrayOrdinalMap(long[] keys, ByteDataBuffer byteData, FreeOrdinalTracker freeOrdinalTracker, int keyArraySize) {
        this.freeOrdinalTracker = freeOrdinalTracker;
        this.byteData = byteData;
        AtomicLongArray pointersAndOrdinals = this.emptyKeyArray(keyArraySize);
        this.populateNewHashArray(pointersAndOrdinals, keys);
        this.pointersAndOrdinals = pointersAndOrdinals;
        this.size = keys.length;
        this.sizeBeforeGrow = keyArraySize * 7 / 10;
    }

    public int getOrAssignOrdinal(ByteDataBuffer serializedRepresentation) {
        int hash = SegmentedByteArrayHasher.hashCode(serializedRepresentation);
        int modBitmask = this.pointersAndOrdinals.length() - 1;
        int bucket = hash & modBitmask;
        long key = this.pointersAndOrdinals.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return (int)(key >> 36);
            }
            bucket = bucket + 1 & modBitmask;
            key = this.pointersAndOrdinals.get(bucket);
        }
        return this.assignOrdinal(serializedRepresentation, hash);
    }

    private synchronized int assignOrdinal(ByteDataBuffer serializedRepresentation, int hash) {
        if (this.size > this.sizeBeforeGrow) {
            this.growKeyArray();
        }
        int modBitmask = this.pointersAndOrdinals.length() - 1;
        int bucket = hash & modBitmask;
        long key = this.pointersAndOrdinals.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return (int)(key >> 36);
            }
            bucket = bucket + 1 & modBitmask;
            key = this.pointersAndOrdinals.get(bucket);
        }
        int ordinal = this.freeOrdinalTracker.getFreeOrdinal();
        long pointer = this.byteData.length();
        VarInt.writeVInt(this.byteData, (int)serializedRepresentation.length());
        serializedRepresentation.copyTo(this.byteData);
        key = (long)ordinal << 36 | pointer;
        ++this.size;
        this.pointersAndOrdinals.set(bucket, key);
        return ordinal;
    }

    public void put(ByteDataBuffer serializedRepresentation, int ordinal) {
        if (this.size > this.sizeBeforeGrow) {
            this.growKeyArray();
        }
        int hash = SegmentedByteArrayHasher.hashCode(serializedRepresentation);
        int modBitmask = this.pointersAndOrdinals.length() - 1;
        int bucket = hash & modBitmask;
        long key = this.pointersAndOrdinals.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return;
            }
            bucket = bucket + 1 & modBitmask;
            key = this.pointersAndOrdinals.get(bucket);
        }
        long pointer = this.byteData.length();
        VarInt.writeVInt(this.byteData, (int)serializedRepresentation.length());
        serializedRepresentation.copyTo(this.byteData);
        key = (long)ordinal << 36 | pointer;
        ++this.size;
        this.pointersAndOrdinals.set(bucket, key);
    }

    public int get(ByteDataBuffer serializedRepresentation) {
        int hash = SegmentedByteArrayHasher.hashCode(serializedRepresentation);
        int modBitmask = this.pointersAndOrdinals.length() - 1;
        int bucket = hash & modBitmask;
        long key = this.pointersAndOrdinals.get(bucket);
        while (key != -1L) {
            if (this.compare(serializedRepresentation, key)) {
                return (int)(key >> 36);
            }
            bucket = bucket + 1 & modBitmask;
            key = this.pointersAndOrdinals.get(bucket);
        }
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            this.pointersAndOrdinals.set(i, -1L);
        }
        this.byteData.reset();
        this.size = 0;
    }

    public int prepareForWrite() {
        int ordinal;
        long key;
        int i;
        int maxOrdinal = 0;
        int maxLength = 0;
        for (i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            key = this.pointersAndOrdinals.get(i);
            if (key == -1L || (ordinal = (int)(key >> 36)) <= maxOrdinal) continue;
            maxOrdinal = ordinal;
        }
        this.pointersByOrdinal = new long[maxOrdinal + 1];
        Arrays.fill(this.pointersByOrdinal, -1L);
        for (i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            key = this.pointersAndOrdinals.get(i);
            if (key == -1L) continue;
            ordinal = (int)(key >> 36);
            this.pointersByOrdinal[ordinal] = key & 0xFFFFFFFFFL;
            int dataLength = VarInt.readVInt(this.byteData.getUnderlyingArray(), this.pointersByOrdinal[ordinal]);
            if (dataLength <= maxLength) continue;
            maxLength = dataLength;
        }
        return maxLength;
    }

    public void compact(ThreadSafeBitSet usedOrdinals) {
        int i;
        long[] populatedReverseKeys = new long[this.size];
        int counter = 0;
        for (int i2 = 0; i2 < this.pointersAndOrdinals.length(); ++i2) {
            long key = this.pointersAndOrdinals.get(i2);
            if (key == -1L) continue;
            populatedReverseKeys[counter++] = key << 28 | key >>> 36;
        }
        Arrays.sort(populatedReverseKeys);
        SegmentedByteArray arr = this.byteData.getUnderlyingArray();
        long currentCopyPointer = 0L;
        for (i = 0; i < populatedReverseKeys.length; ++i) {
            int ordinal = (int)(populatedReverseKeys[i] & 0xFFFFFFFL);
            if (usedOrdinals.get(ordinal)) {
                long pointer = populatedReverseKeys[i] >> 28;
                int length = VarInt.readVInt(arr, pointer);
                length += VarInt.sizeOfVInt(length);
                if (currentCopyPointer != pointer) {
                    arr.copy(arr, pointer, currentCopyPointer, (long)length);
                }
                populatedReverseKeys[i] = populatedReverseKeys[i] << 36 | currentCopyPointer;
                currentCopyPointer += (long)length;
                continue;
            }
            this.freeOrdinalTracker.returnOrdinalToPool(ordinal);
            populatedReverseKeys[i] = -1L;
        }
        this.byteData.setPosition(currentCopyPointer);
        for (i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            this.pointersAndOrdinals.set(i, -1L);
        }
        this.populateNewHashArray(this.pointersAndOrdinals, populatedReverseKeys);
        this.size = usedOrdinals.cardinality();
        this.pointersByOrdinal = null;
    }

    public void writeSerializedObject(OutputStream out, int ordinal) throws IOException {
        long pointer = this.pointersByOrdinal[ordinal] & 0xFFFFFFFFFL;
        int length = VarInt.readVInt(this.byteData.getUnderlyingArray(), pointer);
        this.byteData.getUnderlyingArray().writeTo(out, pointer += (long)VarInt.sizeOfVInt(length), length);
    }

    public boolean isReadyForWriting() {
        return this.pointersByOrdinal != null;
    }

    public boolean isReadyForAddingObjects() {
        return this.pointersByOrdinal == null;
    }

    public long getDataSize() {
        return this.byteData.length();
    }

    void fillDeserializationStateFromData(final FastBlobTypeDeserializationState<?> fill) {
        SimultaneousExecutor executor = new SimultaneousExecutor(1);
        final int numThreads = executor.getMaximumPoolSize();
        fill.ensureCapacity(this.maxOrdinal() + 1);
        int i = 0;
        while (i < numThreads) {
            final int threadNumber = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    FastBlobDeserializationRecord rec = new FastBlobDeserializationRecord(fill.getSchema(), ByteArrayOrdinalMap.this.byteData.getUnderlyingArray());
                    for (int i = threadNumber; i < ByteArrayOrdinalMap.this.pointersAndOrdinals.length(); i += numThreads) {
                        long pointerAndOrdinal = ByteArrayOrdinalMap.this.pointersAndOrdinals.get(i);
                        if (pointerAndOrdinal == -1L) continue;
                        long pointer = pointerAndOrdinal & 0xFFFFFFFFFL;
                        int ordinal = (int)(pointerAndOrdinal >> 36);
                        int sizeOfData = VarInt.readVInt(ByteArrayOrdinalMap.this.byteData.getUnderlyingArray(), pointer);
                        rec.position(pointer += (long)VarInt.sizeOfVInt(sizeOfData));
                        fill.add(ordinal, rec);
                    }
                }
            });
        }
        executor.awaitUninterruptibly();
    }

    void copySerializedObjectData(final FastBlobTypeSerializationState<?> destState, final ThreadSafeBitSet[] imageMemberships, final OrdinalMapping ordinalMapping) {
        final StateOrdinalMapping stateOrdinalMapping = ordinalMapping.createStateOrdinalMapping(destState.getName(), this.maxOrdinal());
        SimultaneousExecutor executor = new SimultaneousExecutor(8);
        final int numThreads = executor.getMaximumPoolSize();
        int i = 0;
        while (i < numThreads) {
            final int threadNumber = i++;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    ByteDataBuffer mappedBuffer = new ByteDataBuffer();
                    FastBlobDeserializationRecord rec = new FastBlobDeserializationRecord(destState.getSchema(), ByteArrayOrdinalMap.this.byteData.getUnderlyingArray());
                    boolean[] imageMembershipsFlags = new boolean[imageMemberships.length];
                    OrdinalRemapper remapper = new OrdinalRemapper(ordinalMapping);
                    for (int j = threadNumber; j < ByteArrayOrdinalMap.this.pointersAndOrdinals.length(); j += numThreads) {
                        long pointerAndOrdinal = ByteArrayOrdinalMap.this.pointersAndOrdinals.get(j);
                        if (pointerAndOrdinal == -1L) continue;
                        long pointer = pointerAndOrdinal & 0xFFFFFFFFFL;
                        int ordinal = (int)(pointerAndOrdinal >> 36);
                        for (int imageIndex = 0; imageIndex < imageMemberships.length; ++imageIndex) {
                            imageMembershipsFlags[imageIndex] = imageMemberships[imageIndex].get(ordinal);
                        }
                        int sizeOfData = VarInt.readVInt(ByteArrayOrdinalMap.this.byteData.getUnderlyingArray(), pointer);
                        rec.position(pointer += (long)VarInt.sizeOfVInt(sizeOfData));
                        remapper.remapOrdinals(rec, mappedBuffer);
                        int newOrdinal = destState.addData(mappedBuffer, FastBlobImageUtils.toLong(imageMembershipsFlags));
                        stateOrdinalMapping.setMappedOrdinal(ordinal, newOrdinal);
                        mappedBuffer.reset();
                    }
                }
            });
        }
        executor.awaitUninterruptibly();
    }

    public int maxOrdinal() {
        int maxOrdinal = 0;
        for (int i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            int ordinal = (int)(this.pointersAndOrdinals.get(i) >> 36);
            if (ordinal <= maxOrdinal) continue;
            maxOrdinal = ordinal;
        }
        return maxOrdinal;
    }

    private boolean compare(ByteDataBuffer serializedRepresentation, long key) {
        long position = key & 0xFFFFFFFFFL;
        int sizeOfData = VarInt.readVInt(this.byteData.getUnderlyingArray(), position);
        if ((long)sizeOfData != serializedRepresentation.length()) {
            return false;
        }
        position += (long)VarInt.sizeOfVInt(sizeOfData);
        for (int i = 0; i < sizeOfData; ++i) {
            if (serializedRepresentation.get(i) == this.byteData.get(position++)) continue;
            return false;
        }
        return true;
    }

    private void growKeyArray() {
        AtomicLongArray newKeys = this.emptyKeyArray(this.pointersAndOrdinals.length() * 2);
        long[] valuesToAdd = new long[this.size];
        int counter = 0;
        for (int i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            long key = this.pointersAndOrdinals.get(i);
            if (key == -1L) continue;
            valuesToAdd[counter++] = key;
        }
        Arrays.sort(valuesToAdd);
        this.populateNewHashArray(newKeys, valuesToAdd);
        this.sizeBeforeGrow = newKeys.length() * 7 / 10;
        this.pointersAndOrdinals = newKeys;
    }

    private void populateNewHashArray(AtomicLongArray newKeys, long[] valuesToAdd) {
        int modBitmask = newKeys.length() - 1;
        for (int i = 0; i < valuesToAdd.length; ++i) {
            if (valuesToAdd[i] == -1L) continue;
            int hash = this.rehashPreviouslyAddedData(valuesToAdd[i]);
            int bucket = hash & modBitmask;
            while (newKeys.get(bucket) != -1L) {
                bucket = bucket + 1 & modBitmask;
            }
            newKeys.set(bucket, valuesToAdd[i]);
        }
    }

    private int rehashPreviouslyAddedData(long key) {
        long position = key & 0xFFFFFFFFFL;
        int sizeOfData = VarInt.readVInt(this.byteData.getUnderlyingArray(), position);
        return SegmentedByteArrayHasher.hashCode(this.byteData.getUnderlyingArray(), position += (long)VarInt.sizeOfVInt(sizeOfData), sizeOfData);
    }

    private AtomicLongArray emptyKeyArray(int size) {
        AtomicLongArray arr = new AtomicLongArray(size);
        for (int i = 0; i < arr.length(); ++i) {
            arr.set(i, -1L);
        }
        return arr;
    }

    public void serializeTo(OutputStream os) throws IOException {
        int i;
        int isPreparedForWrite = this.pointersByOrdinal != null ? 1 : 0;
        os.write(isPreparedForWrite);
        VarInt.writeVInt(os, this.pointersAndOrdinals.length());
        long[] keys = new long[this.size];
        int counter = 0;
        for (i = 0; i < this.pointersAndOrdinals.length(); ++i) {
            long key = this.pointersAndOrdinals.get(i);
            if (key == -1L) continue;
            keys[counter++] = key;
        }
        Arrays.sort(keys);
        VarInt.writeVInt(os, keys.length);
        for (i = 0; i < keys.length; ++i) {
            VarInt.writeVInt(os, (int)(keys[i] >> 36));
            VarInt.writeVLong(os, keys[i] & 0xFFFFFFFFFL);
        }
        VarInt.writeVLong(os, this.byteData.length());
        for (long i2 = 0L; i2 < this.byteData.length(); ++i2) {
            os.write(this.byteData.get(i2) & 0xFF);
        }
        this.freeOrdinalTracker.serializeTo(os);
    }

    public static ByteArrayOrdinalMap deserializeFrom(InputStream is) throws IOException {
        boolean wasPreparedForWrite = is.read() == 1;
        int hashedKeyArraySize = VarInt.readVInt(is);
        long[] keys = new long[VarInt.readVInt(is)];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = VarInt.readVLong(is) << 36 | VarInt.readVLong(is);
        }
        ByteDataBuffer byteData = new ByteDataBuffer(262144);
        long byteDataSize = VarInt.readVLong(is);
        for (long i = 0L; i < byteDataSize; ++i) {
            byteData.write((byte)is.read());
        }
        FreeOrdinalTracker freeOrdinalTracker = FreeOrdinalTracker.deserializeFrom(is);
        ByteArrayOrdinalMap deserializedMap = new ByteArrayOrdinalMap(keys, byteData, freeOrdinalTracker, hashedKeyArraySize);
        if (wasPreparedForWrite) {
            deserializedMap.prepareForWrite();
        }
        return deserializedMap;
    }

    public ByteDataBuffer getByteData() {
        return this.byteData;
    }

    public AtomicLongArray getPointersAndOrdinals() {
        return this.pointersAndOrdinals;
    }

    public static boolean isPointerAndOrdinalEmpty(long pointerAndOrdinal) {
        return pointerAndOrdinal == -1L;
    }

    public static long getPointer(long pointerAndOrdinal) {
        return pointerAndOrdinal & 0xFFFFFFFFFL;
    }

    public static int getOrdinal(long pointerAndOrdinal) {
        return (int)(pointerAndOrdinal >> 36);
    }
}

