/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobDeserializationRecord;
import com.netflix.zeno.fastblob.record.FastBlobSerializationRecord;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.state.ByteArrayOrdinalMap;
import com.netflix.zeno.fastblob.state.ObjectIdentityOrdinalMap;
import com.netflix.zeno.fastblob.state.TypeDeserializationStateIterator;
import com.netflix.zeno.fastblob.state.TypeDeserializationStateListener;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.util.CollectionUnwrapper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;

public class FastBlobTypeDeserializationState<T>
implements Iterable<T> {
    private final NFTypeSerializer<T> serializer;
    private TypeDeserializationStateListener<T> stateListener = TypeDeserializationStateListener.noopCallback();
    private List<T> objects;
    private List<T> previousObjects;
    private BitSet copiedPreviousObjects;
    private ObjectIdentityOrdinalMap identityOrdinalMap;

    public FastBlobTypeDeserializationState(NFTypeSerializer<T> serializer) {
        this.serializer = serializer;
        this.objects = new ArrayList<T>();
    }

    public T get(int ordinal) {
        if (ordinal >= this.objects.size()) {
            return null;
        }
        return this.objects.get(ordinal);
    }

    public void add(int ordinal, FastBlobDeserializationRecord rec) {
        T obj = this.serializer.deserialize(rec);
        this.ensureCapacity(ordinal + 1);
        this.objects.set(ordinal, obj);
        this.stateListener.addedObject(obj);
        this.stateListener.addedObject(obj, ordinal);
    }

    public void remove(int ordinal) {
        T removedObject = this.objects.get(ordinal);
        this.objects.set(ordinal, null);
        this.stateListener.removedObject(removedObject);
        this.stateListener.removedObject(removedObject, ordinal);
    }

    public void setListener(TypeDeserializationStateListener<T> listener) {
        this.stateListener = listener;
    }

    public void populateByteArrayOrdinalMap(ByteArrayOrdinalMap ordinalMap) {
        FastBlobSerializationRecord rec = new FastBlobSerializationRecord(this.serializer.getFastBlobSchema());
        ByteDataBuffer scratch = new ByteDataBuffer();
        for (int i = 0; i < this.objects.size(); ++i) {
            T obj = this.objects.get(i);
            if (obj == null) continue;
            this.serializer.serialize(obj, rec);
            rec.writeDataTo(scratch);
            ordinalMap.put(scratch, i);
            scratch.reset();
            rec.reset();
        }
        this.previousObjects = this.objects;
        this.copiedPreviousObjects = new BitSet(this.previousObjects.size());
        this.objects = new ArrayList<T>(this.previousObjects.size());
    }

    public void populateFromByteOrdinalMap(ByteArrayOrdinalMap ordinalMap) {
        ByteDataBuffer byteData = ordinalMap.getByteData();
        AtomicLongArray pointersAndOrdinals = ordinalMap.getPointersAndOrdinals();
        FastBlobDeserializationRecord rec = new FastBlobDeserializationRecord(this.getSchema(), byteData.getUnderlyingArray());
        for (int i = 0; i < pointersAndOrdinals.length(); ++i) {
            long pointerAndOrdinal = pointersAndOrdinals.get(i);
            if (ByteArrayOrdinalMap.isPointerAndOrdinalEmpty(pointerAndOrdinal)) continue;
            long pointer = ByteArrayOrdinalMap.getPointer(pointerAndOrdinal);
            int ordinal = ByteArrayOrdinalMap.getOrdinal(pointerAndOrdinal);
            int sizeOfData = VarInt.readVInt(byteData.getUnderlyingArray(), pointer);
            rec.position(pointer += (long)VarInt.sizeOfVInt(sizeOfData));
            this.add(ordinal, rec);
        }
    }

    public void createIdentityOrdinalMap() {
        this.identityOrdinalMap = new ObjectIdentityOrdinalMap(this.objects);
    }

    public int find(T obj) {
        if (this.identityOrdinalMap == null) {
            return -1;
        }
        int ordinal = this.identityOrdinalMap.get(obj);
        if (ordinal < 0) {
            ordinal = this.identityOrdinalMap.get(CollectionUnwrapper.unwrap(obj));
        }
        return ordinal;
    }

    public void copyPrevious(int newOrdinal, int previousOrdinal) {
        T obj = this.previousObjects.get(previousOrdinal);
        this.ensureCapacity(newOrdinal + 1);
        this.objects.set(newOrdinal, obj);
        this.copiedPreviousObjects.set(previousOrdinal);
        this.stateListener.reassignedObject(obj, previousOrdinal, newOrdinal);
    }

    public void clearPreviousObjects() {
        for (int i = 0; i < this.previousObjects.size(); ++i) {
            T t = this.previousObjects.get(i);
            if (t == null || this.copiedPreviousObjects.get(i)) continue;
            this.stateListener.removedObject(t);
            this.stateListener.removedObject(t, i);
        }
        this.previousObjects = null;
        this.copiedPreviousObjects = null;
    }

    public void clearIdentityOrdinalMap() {
        this.identityOrdinalMap = null;
    }

    public FastBlobSchema getSchema() {
        return this.serializer.getFastBlobSchema();
    }

    public NFTypeSerializer<T> getSerializer() {
        return this.serializer;
    }

    public int countObjects() {
        int count = 0;
        for (int i = 0; i < this.objects.size(); ++i) {
            if (this.objects.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public int maxOrdinal() {
        int ordinal = this.objects.size();
        while (--ordinal >= 0) {
            if (this.objects.get(ordinal) == null) continue;
            return ordinal;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new TypeDeserializationStateIterator<T>(this.objects);
    }

    void ensureCapacity(int size) {
        while (this.objects.size() < size) {
            this.objects.add(null);
        }
    }

    public void fillSerializationState(FastBlobStateEngine engine) {
        for (T t : this) {
            engine.add(this.serializer.getName(), t);
        }
    }
}

