/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import com.netflix.zeno.fastblob.FastBlobImageUtils;
import com.netflix.zeno.fastblob.OrdinalMapping;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobSerializationRecord;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.state.ByteArrayOrdinalMap;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.fastblob.state.ThreadSafeBitSet;
import com.netflix.zeno.fastblob.state.WeakObjectOrdinalMap;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastBlobTypeSerializationState<T> {
    public final NFTypeSerializer<T> serializer;
    private FastBlobSchema typeSchema;
    private FastBlobSchema previousStateTypeSchema;
    private final ThreadLocal<FastBlobSerializationRecord> serializationRecord;
    private final ThreadLocal<ByteDataBuffer> serializedScratchSpace;
    private ByteArrayOrdinalMap ordinalMap;
    private ThreadSafeBitSet[] imageMemberships;
    private ThreadSafeBitSet[] previousCycleImageMemberships;
    private WeakObjectOrdinalMap objectOrdinalMap;

    public FastBlobTypeSerializationState(NFTypeSerializer<T> serializer, int numImages) {
        this(serializer, numImages, true);
    }

    public FastBlobTypeSerializationState(NFTypeSerializer<T> serializer, int numImages, boolean shouldUseObjectIdentityOrdinalCaching) {
        this.serializer = serializer;
        this.typeSchema = serializer.getFastBlobSchema();
        this.serializationRecord = new ThreadLocal();
        this.serializedScratchSpace = new ThreadLocal();
        this.ordinalMap = new ByteArrayOrdinalMap();
        this.imageMemberships = this.initializeImageMembershipBitSets(numImages);
        this.previousCycleImageMemberships = this.initializeImageMembershipBitSets(numImages);
        if (shouldUseObjectIdentityOrdinalCaching) {
            this.objectOrdinalMap = new WeakObjectOrdinalMap(8);
        }
    }

    public String getName() {
        return this.serializer.getName();
    }

    public FastBlobSchema getSchema() {
        return this.typeSchema;
    }

    public FastBlobSchema getPreviousStateSchema() {
        return this.previousStateTypeSchema;
    }

    @Deprecated
    public int add(T data, boolean[] imageMembershipsFlags) {
        return this.add(data, FastBlobImageUtils.toLong(imageMembershipsFlags));
    }

    public int add(T data, long imageMembershipsFlags) {
        WeakObjectOrdinalMap.Entry existingEntry;
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The FastBlobStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        if (this.objectOrdinalMap != null && (existingEntry = this.objectOrdinalMap.getEntry(data)) != null && existingEntry.hasImageMembershipsFlags(imageMembershipsFlags)) {
            return existingEntry.getOrdinal();
        }
        FastBlobSerializationRecord rec = this.record();
        rec.setImageMembershipsFlags(imageMembershipsFlags);
        this.serializer.serialize(data, rec);
        ByteDataBuffer scratch = this.scratch();
        rec.writeDataTo(scratch);
        int ordinal = this.addData(scratch, imageMembershipsFlags);
        scratch.reset();
        rec.reset();
        if (this.objectOrdinalMap != null) {
            this.objectOrdinalMap.put(data, ordinal, imageMembershipsFlags);
        }
        return ordinal;
    }

    @Deprecated
    public int addData(ByteDataBuffer data, boolean[] imageMembershipsFlags) {
        return this.addData(data, FastBlobImageUtils.toLong(imageMembershipsFlags));
    }

    public int addData(ByteDataBuffer data, long imageMembershipsFlags) {
        int ordinal = this.ordinalMap.getOrAssignOrdinal(data);
        this.addOrdinalToImages(imageMembershipsFlags, ordinal);
        return ordinal;
    }

    public void copyTo(FastBlobTypeSerializationState<?> otherState, OrdinalMapping ordinalMapping) {
        this.ordinalMap.copySerializedObjectData(otherState, this.imageMemberships, ordinalMapping);
    }

    public void fillDeserializationState(FastBlobTypeDeserializationState<?> otherState) {
        otherState.populateFromByteOrdinalMap(this.ordinalMap);
    }

    public int prepareForWrite() {
        int maxLengthOfAnyRecord = this.ordinalMap.prepareForWrite();
        return maxLengthOfAnyRecord;
    }

    public void prepareForNextCycle() {
        ThreadSafeBitSet usedOrdinals = ThreadSafeBitSet.orAll(this.imageMemberships);
        this.ordinalMap.compact(usedOrdinals);
        ThreadSafeBitSet[] temp = this.previousCycleImageMemberships;
        this.previousCycleImageMemberships = this.imageMemberships;
        this.imageMemberships = temp;
        this.previousStateTypeSchema = this.typeSchema;
        this.typeSchema = this.serializer.getFastBlobSchema();
        for (ThreadSafeBitSet bitSet : this.imageMemberships) {
            bitSet.clearAll();
        }
        if (this.objectOrdinalMap != null) {
            this.objectOrdinalMap.clear();
        }
    }

    public void writeObjectTo(OutputStream os, int ordinal) throws IOException {
        this.ordinalMap.writeSerializedObject(os, ordinal);
    }

    public boolean isReadyForWriting() {
        return this.ordinalMap.isReadyForWriting();
    }

    public ThreadSafeBitSet getImageMembershipBitSet(int imageIndex) {
        return this.imageMemberships[imageIndex];
    }

    public ThreadSafeBitSet getPreviousCycleImageMembershipBitSet(int imageIndex) {
        return this.previousCycleImageMemberships[imageIndex];
    }

    private void addOrdinalToImages(long imageMembershipsFlags, int ordinal) {
        int count = 0;
        while (imageMembershipsFlags != 0L) {
            if ((imageMembershipsFlags & 1L) != 0L) {
                this.imageMemberships[count].set(ordinal);
            }
            imageMembershipsFlags >>>= 1;
            ++count;
        }
    }

    private ThreadSafeBitSet[] initializeImageMembershipBitSets(int numImages) {
        ThreadSafeBitSet[] sets = new ThreadSafeBitSet[numImages];
        for (int i = 0; i < numImages; ++i) {
            sets[i] = new ThreadSafeBitSet();
        }
        return sets;
    }

    private ByteDataBuffer scratch() {
        ByteDataBuffer scratch = this.serializedScratchSpace.get();
        if (scratch == null) {
            scratch = new ByteDataBuffer(32);
            this.serializedScratchSpace.set(scratch);
        }
        return scratch;
    }

    private FastBlobSerializationRecord record() {
        FastBlobSerializationRecord rec = this.serializationRecord.get();
        if (rec == null) {
            rec = new FastBlobSerializationRecord(this.typeSchema);
            this.serializationRecord.set(rec);
        }
        return rec;
    }

    public void serializeTo(DataOutputStream os) throws IOException {
        this.typeSchema.writeTo(os);
        this.ordinalMap.serializeTo(os);
        for (ThreadSafeBitSet bitSet : this.imageMemberships) {
            bitSet.serializeTo(os);
        }
    }

    public void deserializeFrom(DataInputStream is, int numConfigs) throws IOException {
        this.typeSchema = FastBlobSchema.readFrom(is);
        this.ordinalMap = ByteArrayOrdinalMap.deserializeFrom(is);
        for (int i = 0; i < numConfigs; ++i) {
            ThreadSafeBitSet bitSet;
            this.imageMemberships[i] = bitSet = ThreadSafeBitSet.deserializeFrom(is);
        }
    }

    public static void discardSerializedTypeSerializationState(DataInputStream is, int numConfigs) throws IOException {
        FastBlobSchema.readFrom(is);
        ByteArrayOrdinalMap.deserializeFrom(is);
        for (int i = 0; i < numConfigs; ++i) {
            ThreadSafeBitSet.deserializeFrom(is);
        }
    }
}

