/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import com.netflix.zeno.fastblob.record.VarInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class FreeOrdinalTracker {
    private int[] freeOrdinals = new int[64];
    private int size;
    private int nextEmptyOrdinal;

    public FreeOrdinalTracker() {
        this(0);
    }

    private FreeOrdinalTracker(int nextEmptyOrdinal) {
        this.nextEmptyOrdinal = nextEmptyOrdinal;
        this.size = 0;
    }

    public int getFreeOrdinal() {
        if (this.size == 0) {
            return this.nextEmptyOrdinal++;
        }
        return this.freeOrdinals[--this.size];
    }

    public void returnOrdinalToPool(int ordinal) {
        if (this.size == this.freeOrdinals.length) {
            this.freeOrdinals = Arrays.copyOf(this.freeOrdinals, this.freeOrdinals.length * 3 / 2);
        }
        this.freeOrdinals[this.size] = ordinal;
        ++this.size;
    }

    public void serializeTo(OutputStream os) throws IOException {
        VarInt.writeVInt(os, this.nextEmptyOrdinal);
        VarInt.writeVInt(os, this.size);
        for (int i = 0; i < this.size; ++i) {
            VarInt.writeVInt(os, this.freeOrdinals[i]);
        }
    }

    public static FreeOrdinalTracker deserializeFrom(InputStream is) throws IOException {
        int nextEmptyOrdinal = VarInt.readVInt(is);
        FreeOrdinalTracker tracker = new FreeOrdinalTracker(nextEmptyOrdinal);
        int numFreeOrdinals = VarInt.readVInt(is);
        for (int i = 0; i < numFreeOrdinals; ++i) {
            tracker.returnOrdinalToPool(VarInt.readVInt(is));
        }
        return tracker;
    }
}

