/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import java.util.Arrays;
import java.util.List;

public class ObjectIdentityOrdinalMap {
    private final List<Object> objects;
    private final int[] hashedOrdinals;
    private final int hashModMask;

    public ObjectIdentityOrdinalMap(List objects) {
        int size = 0;
        for (int i = 0; i < objects.size(); ++i) {
            if (objects.get(i) == null) continue;
            ++size;
        }
        int arraySize = size * 10 / 8;
        arraySize = 1 << 32 - Integer.numberOfLeadingZeros(arraySize);
        this.hashedOrdinals = new int[arraySize];
        this.hashModMask = arraySize - 1;
        Arrays.fill(this.hashedOrdinals, -1);
        for (int i = 0; i < objects.size(); ++i) {
            if (objects.get(i) == null) continue;
            this.put(objects.get(i), i);
        }
        this.objects = objects;
    }

    private void put(Object obj, int ordinal) {
        int hash = this.rehash(System.identityHashCode(obj));
        int bucket = hash & this.hashModMask;
        while (this.hashedOrdinals[bucket] != -1) {
            bucket = bucket + 1 & this.hashModMask;
        }
        this.hashedOrdinals[bucket] = ordinal;
    }

    public int get(Object obj) {
        int hash = this.rehash(System.identityHashCode(obj));
        int bucket = hash & this.hashModMask;
        while (this.hashedOrdinals[bucket] != -1) {
            if (this.objects.get(this.hashedOrdinals[bucket]) == obj) {
                return this.hashedOrdinals[bucket];
            }
            bucket = bucket + 1 & this.hashModMask;
        }
        return -1;
    }

    private int rehash(int hash) {
        hash = ~hash + (hash << 15);
        hash ^= hash >>> 12;
        hash += hash << 2;
        hash ^= hash >>> 4;
        hash *= 2057;
        hash ^= hash >>> 16;
        return hash & Integer.MAX_VALUE;
    }
}

