/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import com.netflix.zeno.fastblob.OrdinalMapping;
import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.FastBlobDeserializationRecord;
import com.netflix.zeno.fastblob.record.SegmentedByteArray;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.record.schema.FieldDefinition;
import com.netflix.zeno.fastblob.record.schema.MapFieldDefinition;
import com.netflix.zeno.fastblob.record.schema.TypedFieldDefinition;
import java.util.Arrays;

public class OrdinalRemapper {
    private final ByteDataBuffer scratch;
    private final OrdinalMapping ordinalMapping;

    public OrdinalRemapper(OrdinalMapping ordinalMapping) {
        this.ordinalMapping = ordinalMapping;
        this.scratch = new ByteDataBuffer();
    }

    public void remapOrdinals(FastBlobDeserializationRecord rec, ByteDataBuffer toBuffer) {
        FastBlobSchema schema = rec.getSchema();
        ByteData fromSpace = rec.getByteData();
        long currentPointerPosition = rec.position();
        block6: for (int i = 0; i < schema.numFields(); ++i) {
            FieldDefinition fieldDef = schema.getFieldDefinition(i);
            int length = rec.getFieldLength(schema.getFieldName(i));
            switch (fieldDef.getFieldType()) {
                case OBJECT: {
                    TypedFieldDefinition typedFieldDef = (TypedFieldDefinition)fieldDef;
                    if (VarInt.readVNull(fromSpace, currentPointerPosition)) {
                        VarInt.writeVNull(toBuffer);
                        ++currentPointerPosition;
                        continue block6;
                    }
                    int ordinal = VarInt.readVInt(fromSpace, currentPointerPosition);
                    currentPointerPosition += (long)VarInt.sizeOfVInt(ordinal);
                    int mappedOrdinal = this.getMappedOrdinal(typedFieldDef.getSubType(), ordinal);
                    VarInt.writeVInt(toBuffer, mappedOrdinal);
                    continue block6;
                }
                case SET: {
                    TypedFieldDefinition typedFieldDef = (TypedFieldDefinition)fieldDef;
                    currentPointerPosition = this.copySetWithRemappedOrdinals(fromSpace, currentPointerPosition, toBuffer, typedFieldDef.getSubType());
                    continue block6;
                }
                case LIST: {
                    TypedFieldDefinition typedFieldDef = (TypedFieldDefinition)fieldDef;
                    currentPointerPosition = this.copyListWithRemappedOrdinals(toBuffer, fromSpace, currentPointerPosition, typedFieldDef.getSubType());
                    continue block6;
                }
                case MAP: {
                    MapFieldDefinition mapFieldDef = (MapFieldDefinition)fieldDef;
                    currentPointerPosition = this.copyMapWithRemappedOrdinals(toBuffer, fromSpace, currentPointerPosition, mapFieldDef);
                    continue block6;
                }
                default: {
                    if (fromSpace instanceof SegmentedByteArray) {
                        toBuffer.copyFrom((SegmentedByteArray)fromSpace, currentPointerPosition, length);
                    } else {
                        toBuffer.copyFrom(fromSpace, currentPointerPosition, length);
                    }
                    currentPointerPosition += (long)length;
                }
            }
        }
    }

    private long copyListWithRemappedOrdinals(ByteDataBuffer toSpace, ByteData fromSpace, long pointer, String elementType) {
        int sizeOfData = VarInt.readVInt(fromSpace, pointer);
        pointer += (long)VarInt.sizeOfVInt(sizeOfData);
        int readBytesCounter = 0;
        while (readBytesCounter < sizeOfData) {
            if (VarInt.readVNull(fromSpace, pointer)) {
                VarInt.writeVNull(this.scratch);
                ++pointer;
                ++readBytesCounter;
                continue;
            }
            int ordinal = VarInt.readVInt(fromSpace, pointer);
            int sizeOfOrdinal = VarInt.sizeOfVInt(ordinal);
            pointer += (long)sizeOfOrdinal;
            readBytesCounter += sizeOfOrdinal;
            int mappedOrdinal = this.getMappedOrdinal(elementType, ordinal);
            VarInt.writeVInt(this.scratch, mappedOrdinal);
        }
        VarInt.writeVInt(toSpace, (int)this.scratch.length());
        toSpace.copyFrom(this.scratch.getUnderlyingArray(), 0L, (int)this.scratch.length());
        this.scratch.reset();
        return pointer;
    }

    private long copySetWithRemappedOrdinals(ByteData fromSpace, long pointer, ByteDataBuffer toSpace, String elementType) {
        int sizeOfData = VarInt.readVInt(fromSpace, pointer);
        pointer += (long)VarInt.sizeOfVInt(sizeOfData);
        int readBytesCounter = 0;
        int readOrdinalsCounter = 0;
        int currentOrdinal = 0;
        int[] mappedOrdinals = new int[sizeOfData];
        while (readBytesCounter < sizeOfData) {
            if (VarInt.readVNull(fromSpace, pointer)) {
                mappedOrdinals[readOrdinalsCounter++] = -1;
                ++pointer;
                ++readBytesCounter;
                continue;
            }
            int ordinalDelta = VarInt.readVInt(fromSpace, pointer);
            int sizeOfOrdinalDelta = VarInt.sizeOfVInt(ordinalDelta);
            pointer += (long)sizeOfOrdinalDelta;
            readBytesCounter += sizeOfOrdinalDelta;
            int mappedOrdinal = this.getMappedOrdinal(elementType, currentOrdinal += ordinalDelta);
            mappedOrdinals[readOrdinalsCounter++] = mappedOrdinal;
        }
        Arrays.sort(mappedOrdinals, 0, readOrdinalsCounter);
        currentOrdinal = 0;
        for (int j = 0; j < readOrdinalsCounter; ++j) {
            if (mappedOrdinals[j] == -1) {
                VarInt.writeVNull(this.scratch);
                continue;
            }
            VarInt.writeVInt(this.scratch, mappedOrdinals[j] - currentOrdinal);
            currentOrdinal = mappedOrdinals[j];
        }
        VarInt.writeVInt(toSpace, (int)this.scratch.length());
        toSpace.copyFrom(this.scratch.getUnderlyingArray(), 0L, (int)this.scratch.length());
        this.scratch.reset();
        return pointer;
    }

    private long copyMapWithRemappedOrdinals(ByteDataBuffer toSpace, ByteData fromSpace, long pointer, MapFieldDefinition mapFieldDef) {
        int sizeOfValueOrdinalDelta;
        int sizeOfKeyOrdinal;
        int sizeOfData = VarInt.readVInt(fromSpace, pointer);
        long[] mapEntries = new long[sizeOfData / 2];
        pointer += (long)VarInt.sizeOfVInt(sizeOfData);
        int currentValueOrdinal = 0;
        int readMapEntries = 0;
        for (int readBytesCounter = 0; readBytesCounter < sizeOfData; readBytesCounter += sizeOfKeyOrdinal + sizeOfValueOrdinalDelta) {
            int keyOrdinal = -1;
            sizeOfKeyOrdinal = 1;
            if (VarInt.readVNull(fromSpace, pointer)) {
                ++pointer;
            } else {
                keyOrdinal = VarInt.readVInt(fromSpace, pointer);
                sizeOfKeyOrdinal = VarInt.sizeOfVInt(keyOrdinal);
                pointer += (long)sizeOfKeyOrdinal;
            }
            int valueOrdinalDelta = -1;
            sizeOfValueOrdinalDelta = 1;
            if (VarInt.readVNull(fromSpace, pointer)) {
                ++pointer;
            } else {
                valueOrdinalDelta = VarInt.readVInt(fromSpace, pointer);
                sizeOfValueOrdinalDelta = VarInt.sizeOfVInt(valueOrdinalDelta);
                pointer += (long)sizeOfValueOrdinalDelta;
                currentValueOrdinal += valueOrdinalDelta;
            }
            int mappedKeyOrdinal = keyOrdinal == -1 ? -1 : this.getMappedOrdinal(mapFieldDef.getKeyType(), keyOrdinal);
            int mappedValueOrdinal = valueOrdinalDelta == -1 ? -1 : this.getMappedOrdinal(mapFieldDef.getValueType(), currentValueOrdinal);
            mapEntries[readMapEntries++] = mappedValueOrdinal == -1 ? 0xFFFFFFFF00000000L | (long)mappedKeyOrdinal : (long)mappedValueOrdinal << 32 | (long)mappedKeyOrdinal & 0xFFFFFFFFL;
        }
        Arrays.sort(mapEntries, 0, readMapEntries);
        currentValueOrdinal = 0;
        for (int j = 0; j < readMapEntries; ++j) {
            int valueOrdinal = (int)(mapEntries[j] >> 32);
            int keyOrdinal = (int)(mapEntries[j] & 0xFFFFFFFFL);
            if (keyOrdinal == -1) {
                VarInt.writeVNull(this.scratch);
            } else {
                VarInt.writeVInt(this.scratch, keyOrdinal);
            }
            if (valueOrdinal == -1) {
                VarInt.writeVNull(this.scratch);
                continue;
            }
            VarInt.writeVInt(this.scratch, valueOrdinal - currentValueOrdinal);
            currentValueOrdinal = valueOrdinal;
        }
        VarInt.writeVInt(toSpace, (int)this.scratch.length());
        toSpace.copyFrom(this.scratch.getUnderlyingArray(), 0L, (int)this.scratch.length());
        this.scratch.reset();
        return pointer;
    }

    private int getMappedOrdinal(String type, int fromOrdinal) {
        return this.ordinalMapping.getStateOrdinalMapping(type).getMappedOrdinal(fromOrdinal);
    }
}

