/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state;

import java.util.Iterator;
import java.util.List;

public class TypeDeserializationStateIterator<T>
implements Iterator<T> {
    private final List<T> list;
    private int currentOrdinal = 0;

    public TypeDeserializationStateIterator(List<T> stateList) {
        this.list = stateList;
        this.currentOrdinal = -1;
        this.moveToNext();
    }

    @Override
    public boolean hasNext() {
        return this.currentOrdinal < this.list.size();
    }

    @Override
    public T next() {
        T current = this.list.get(this.currentOrdinal);
        this.moveToNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void moveToNext() {
        ++this.currentOrdinal;
        while (this.currentOrdinal < this.list.size()) {
            if (this.list.get(this.currentOrdinal) != null) {
                return;
            }
            ++this.currentOrdinal;
        }
    }
}

