/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.fastblob.state.compressed;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.VarInt;
import java.util.Arrays;

public class ByteSequenceRetainer {
    private static final long EMPTY_BUCKET_VALUE = -1L;
    private long[] keys;
    private final ByteDataBuffer buf = new ByteDataBuffer(262144);
    private int size;
    private int sizeBeforeGrow;

    public ByteSequenceRetainer() {
        this.keys = new long[256];
        Arrays.fill(this.keys, -1L);
        this.size = 0;
        this.sizeBeforeGrow = 179;
    }

    public void addByteSequence(int ordinal, ByteData readSequenceFrom, long seqPointer, int seqLength) {
        if (this.size == this.sizeBeforeGrow) {
            this.growKeyArray();
        }
        long key = (long)ordinal << 36 | this.buf.length();
        int bucket = this.hashInt(ordinal) % this.keys.length;
        while (this.keys[bucket] != -1L) {
            ++bucket;
            bucket %= this.keys.length;
        }
        VarInt.writeVInt(this.buf, seqLength);
        this.buf.copyFrom(readSequenceFrom, seqPointer, seqLength);
        this.keys[bucket] = key;
        ++this.size;
    }

    public int retrieveSequence(int ordinal, ByteDataBuffer writeTo) {
        int bucket = this.hashInt(ordinal) % this.keys.length;
        while (this.keys[bucket] != -1L) {
            int foundOrdinal = (int)(this.keys[bucket] >>> 36);
            if (foundOrdinal != ordinal) continue;
            long pointer = this.keys[bucket] & 0xFFFFFFFFFL;
            int length = VarInt.readVInt(this.buf.getUnderlyingArray(), pointer);
            writeTo.copyFrom(this.buf.getUnderlyingArray(), pointer += (long)VarInt.sizeOfVInt(length), length);
            return length;
        }
        return 0;
    }

    public ByteSequenceRetainerIterator iterator() {
        return new ByteSequenceRetainerIterator(this.keys, this.size, this.buf.getUnderlyingArray());
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.keys, -1L);
        this.buf.reset();
    }

    private void growKeyArray() {
        long[] newKeys = new long[this.keys.length * 2];
        Arrays.fill(newKeys, -1L);
        long[] keysToAdd = ByteSequenceRetainer.sortedPopulatedKeysArray(this.keys, this.size);
        this.populateNewHashArray(newKeys, keysToAdd);
        this.keys = newKeys;
        this.sizeBeforeGrow = newKeys.length * 7 / 10;
    }

    private void populateNewHashArray(long[] newKeys, long[] valuesToAdd) {
        int modBitmask = newKeys.length - 1;
        for (int i = 0; i < valuesToAdd.length; ++i) {
            int ordinal = (int)(valuesToAdd[i] >>> 36);
            int hash = this.hashInt(ordinal);
            int bucket = hash & modBitmask;
            while (newKeys[bucket] != -1L) {
                bucket = bucket + 1 & modBitmask;
            }
            newKeys[bucket] = valuesToAdd[i];
        }
    }

    private int hashInt(int hash) {
        hash = ~hash + (hash << 15);
        hash ^= hash >>> 12;
        hash += hash << 2;
        hash ^= hash >>> 4;
        hash *= 2057;
        hash ^= hash >>> 16;
        return hash & Integer.MAX_VALUE;
    }

    private static long[] sortedPopulatedKeysArray(long[] keys, int size) {
        long[] arr = new long[size];
        int counter = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == -1L) continue;
            arr[counter++] = keys[i];
        }
        Arrays.sort(arr);
        return arr;
    }

    static class ByteSequenceRetainerIterator {
        private final long[] keysToAdd;
        private final ByteData dataArray;
        private int currentKeyIndex;
        private int currentOrdinal;
        private int currentDataSize;
        private long currentPointer;

        private ByteSequenceRetainerIterator(long[] keyArray, int size, ByteData dataArray) {
            this.keysToAdd = ByteSequenceRetainer.sortedPopulatedKeysArray(keyArray, size);
            this.dataArray = dataArray;
            this.currentKeyIndex = -1;
        }

        public boolean nextKey() {
            ++this.currentKeyIndex;
            if (this.currentKeyIndex < this.keysToAdd.length) {
                this.currentOrdinal = (int)(this.keysToAdd[this.currentKeyIndex] >> 36);
                this.currentPointer = this.keysToAdd[this.currentKeyIndex] & 0xFFFFFFFFFL;
                this.currentDataSize = VarInt.readVInt(this.dataArray, this.currentPointer);
                this.currentPointer += (long)VarInt.sizeOfVInt(this.currentDataSize);
                return true;
            }
            return false;
        }

        public int getCurrentOrdinal() {
            return this.currentOrdinal;
        }

        public int getCurrentDataSize() {
            return this.currentDataSize;
        }

        public long getCurrentPointer() {
            return this.currentPointer;
        }

        public void copyEntryTo(ByteSequenceRetainer other) {
            other.addByteSequence(this.currentOrdinal, this.dataArray, this.currentPointer, this.currentDataSize);
        }
    }
}

