/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;

public class FlatBlobDeserializationRecord
extends NFDeserializationRecord {
    private final long[] fieldPointers;
    private ByteData byteData;
    private boolean cacheElements;

    public FlatBlobDeserializationRecord(FastBlobSchema schema) {
        super(schema);
        this.fieldPointers = new long[schema.numFields()];
    }

    public void setByteData(ByteData byteData) {
        this.byteData = byteData;
    }

    public void setCacheElements(boolean cacheElements) {
        this.cacheElements = cacheElements;
    }

    public boolean shouldCacheElements() {
        return this.cacheElements;
    }

    public int position(long objectBeginOffset) {
        long currentPosition = objectBeginOffset;
        for (int i = 0; i < this.fieldPointers.length; ++i) {
            this.fieldPointers[i] = currentPosition;
            FastBlobSchema.FieldType type = this.getSchema().getFieldType(i);
            currentPosition += (long)this.fieldLength(currentPosition, type);
        }
        return (int)(currentPosition - objectBeginOffset);
    }

    public ByteData getByteData() {
        return this.byteData;
    }

    public long getPosition(String fieldName) {
        int fieldPosition = this.getSchema().getPosition(fieldName);
        if (fieldPosition == -1) {
            return -1L;
        }
        return this.fieldPointers[fieldPosition];
    }

    @Override
    public String getObjectType(String fieldName) {
        return this.getSchema().getObjectType(fieldName);
    }

    private int fieldLength(long currentPosition, FastBlobSchema.FieldType type) {
        if (type.startsWithVarIntEncodedLength()) {
            if (VarInt.readVNull(this.byteData, currentPosition)) {
                return 1;
            }
            int fieldLength = VarInt.readVInt(this.byteData, currentPosition);
            return VarInt.sizeOfVInt(fieldLength) + fieldLength;
        }
        if (type.equals((Object)FastBlobSchema.FieldType.OBJECT)) {
            if (VarInt.readVNull(this.byteData, currentPosition)) {
                return 1;
            }
            int ordinal = VarInt.readVInt(this.byteData, currentPosition);
            int sizeOfOrdinal = VarInt.sizeOfVInt(ordinal);
            if (VarInt.readVNull(this.byteData, currentPosition + (long)sizeOfOrdinal)) {
                System.out.println(this.getSchema().getName());
            }
            int flatDataSize = VarInt.readVInt(this.byteData, currentPosition + (long)sizeOfOrdinal);
            return VarInt.sizeOfVInt(flatDataSize) + sizeOfOrdinal + flatDataSize;
        }
        if (type.getFixedLength() != -1) {
            return type.getFixedLength();
        }
        if (VarInt.readVNull(this.byteData, currentPosition)) {
            return 1;
        }
        long value = VarInt.readVLong(this.byteData, currentPosition);
        return VarInt.sizeOfVLong(value);
    }
}

