/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.flatblob.FlatBlobEvictor;
import com.netflix.zeno.flatblob.FlatBlobSerializationFramework;
import com.netflix.zeno.flatblob.FlatBlobSerializationRecord;
import com.netflix.zeno.flatblob.FlatBlobTypeCache;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FlatBlobEvictionFrameworkSerializer
extends FrameworkSerializer<FlatBlobSerializationRecord> {
    private final FlatBlobSerializationFramework flatBlobFramework;

    public FlatBlobEvictionFrameworkSerializer(FlatBlobEvictor evictor, FlatBlobSerializationFramework flatBlobFramework) {
        super(evictor);
        this.flatBlobFramework = flatBlobFramework;
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, Object value) {
    }

    @Override
    public void serializeBytes(FlatBlobSerializationRecord rec, String fieldName, byte[] value) {
    }

    @Override
    @Deprecated
    public void serializeObject(FlatBlobSerializationRecord rec, String fieldName, String typeName, Object obj) {
        this.getSerializer(typeName).serialize(obj, rec);
        this.flatBlobFramework.getTypeCache(typeName).evict(obj);
    }

    @Override
    public void serializeObject(FlatBlobSerializationRecord rec, String fieldName, Object obj) {
        this.serializeObject(rec, fieldName, rec.getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(FlatBlobSerializationRecord rec, String fieldName, String typeName, Collection<T> obj) {
        FlatBlobTypeCache<T> typeCache = this.flatBlobFramework.getTypeCache(typeName);
        NFTypeSerializer serializer = this.getSerializer(typeName);
        for (T t : obj) {
            serializer.serialize(t, rec);
            typeCache.evict(t);
        }
    }

    @Override
    public <T> void serializeSet(FlatBlobSerializationRecord rec, String fieldName, String typeName, Set<T> obj) {
        this.serializeList(rec, fieldName, typeName, (Collection<T>)obj);
    }

    @Override
    public <K, V> void serializeMap(FlatBlobSerializationRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> obj) {
        FlatBlobTypeCache<K> keyCache = this.flatBlobFramework.getTypeCache(keyTypeName);
        FlatBlobTypeCache<V> valueCache = this.flatBlobFramework.getTypeCache(valueTypeName);
        NFTypeSerializer keySerializer = this.getSerializer(keyTypeName);
        NFTypeSerializer valueSerializer = this.getSerializer(valueTypeName);
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            keySerializer.serialize(entry.getKey(), rec);
            keyCache.evict(entry.getKey());
            valueSerializer.serialize(entry.getValue(), rec);
            valueCache.evict(entry.getValue());
        }
    }
}

