/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.flatblob.FlatBlobDeserializationRecord;
import com.netflix.zeno.flatblob.FlatBlobFrameworkSerializer;
import com.netflix.zeno.flatblob.FlatBlobSerializationFramework;
import com.netflix.zeno.flatblob.FlatBlobTypeCache;
import com.netflix.zeno.serializer.FrameworkDeserializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.util.collections.CollectionImplementation;
import com.netflix.zeno.util.collections.MinimizedUnmodifiableCollections;
import com.netflix.zeno.util.collections.builder.ListBuilder;
import com.netflix.zeno.util.collections.builder.MapBuilder;
import com.netflix.zeno.util.collections.builder.SetBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class FlatBlobFrameworkDeserializer
extends FrameworkDeserializer<FlatBlobDeserializationRecord> {
    private final Map<String, FlatBlobTypeCache<?>> typeCaches;
    private final ThreadLocal<Map<String, FlatBlobDeserializationRecord>> deserializationRecords;
    private MinimizedUnmodifiableCollections minimizedCollections = new MinimizedUnmodifiableCollections(CollectionImplementation.JAVA_UTIL);
    private final ThreadLocal<char[]> chararr = new ThreadLocal();

    public void setCollectionImplementation(CollectionImplementation impl) {
        this.minimizedCollections = new MinimizedUnmodifiableCollections(impl);
    }

    protected FlatBlobFrameworkDeserializer(FlatBlobSerializationFramework framework) {
        super(framework);
        this.typeCaches = new HashMap();
        this.deserializationRecords = new ThreadLocal();
        for (NFTypeSerializer<?> serializer : framework.getOrderedSerializers()) {
            this.typeCaches.put(serializer.getName(), new FlatBlobTypeCache(serializer.getName()));
        }
    }

    @Override
    public Boolean deserializeBoolean(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        return byteData.get(fieldPosition) == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean deserializePrimitiveBoolean(FlatBlobDeserializationRecord rec, String fieldName) {
        long fieldPosition;
        ByteData byteData = rec.getByteData();
        return byteData.get(fieldPosition = rec.getPosition(fieldName)) == 1;
    }

    @Override
    public Integer deserializeInteger(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int value = VarInt.readVInt(byteData, fieldPosition);
        return value >>> 1 ^ value << 31 >> 31;
    }

    @Override
    public int deserializePrimitiveInt(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        int value = VarInt.readVInt(byteData, fieldPosition);
        return value >>> 1 ^ value << 31 >> 31;
    }

    @Override
    public Long deserializeLong(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        long value = VarInt.readVLong(byteData, fieldPosition);
        return value >>> 1 ^ value << 63 >> 63;
    }

    @Override
    public long deserializePrimitiveLong(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        long value = VarInt.readVLong(byteData, fieldPosition);
        return value >>> 1 ^ value << 63 >> 63;
    }

    @Override
    public Float deserializeFloat(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        int intBits = this.readIntBits(byteData, fieldPosition);
        if (intBits == FlatBlobFrameworkSerializer.NULL_FLOAT_BITS) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(intBits));
    }

    @Override
    public float deserializePrimitiveFloat(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        int intBits = this.readIntBits(byteData, fieldPosition);
        return Float.intBitsToFloat(intBits);
    }

    private int readIntBits(ByteData byteData, long fieldPosition) {
        int intBits = (byteData.get(fieldPosition++) & 0xFF) << 24;
        intBits |= (byteData.get(fieldPosition++) & 0xFF) << 16;
        intBits |= (byteData.get(fieldPosition++) & 0xFF) << 8;
        return intBits |= byteData.get(fieldPosition) & 0xFF;
    }

    @Override
    public Double deserializeDouble(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L) {
            return null;
        }
        long longBits = this.readLongBits(byteData, fieldPosition);
        if (longBits == FlatBlobFrameworkSerializer.NULL_DOUBLE_BITS) {
            return null;
        }
        return Double.longBitsToDouble(longBits);
    }

    @Override
    public double deserializePrimitiveDouble(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        long longBits = this.readLongBits(byteData, fieldPosition);
        return Double.longBitsToDouble(longBits);
    }

    private long readLongBits(ByteData byteData, long fieldPosition) {
        long longBits = (long)(byteData.get(fieldPosition++) & 0xFF) << 56;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 48;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 40;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 32;
        longBits |= (long)(byteData.get(fieldPosition++) & 0xFF) << 24;
        longBits |= (long)((byteData.get(fieldPosition++) & 0xFF) << 16);
        longBits |= (long)((byteData.get(fieldPosition++) & 0xFF) << 8);
        return longBits |= (long)(byteData.get(fieldPosition) & 0xFF);
    }

    @Override
    public String deserializeString(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        return this.readString(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
    }

    @Override
    public byte[] deserializeBytes(FlatBlobDeserializationRecord rec, String fieldName) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        fieldPosition += (long)VarInt.sizeOfVInt(length);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = byteData.get(fieldPosition++);
        }
        return data;
    }

    @Override
    public <T> T deserializeObject(FlatBlobDeserializationRecord rec, String fieldName, Class<T> clazz) {
        long position = rec.getPosition(fieldName);
        if (position == -1L) {
            return null;
        }
        return this.deserializeObject(rec, position, rec.getObjectType(fieldName));
    }

    @Override
    @Deprecated
    public <T> T deserializeObject(FlatBlobDeserializationRecord rec, String fieldName, String typeName, Class<T> clazz) {
        long position = rec.getPosition(fieldName);
        if (position == -1L) {
            return null;
        }
        return this.deserializeObject(rec, position, typeName);
    }

    private <T> T deserializeObject(FlatBlobDeserializationRecord rec, long position, String typeName) {
        ByteData underlyingData = rec.getByteData();
        if (position == -1L || VarInt.readVNull(underlyingData, position)) {
            return null;
        }
        int ordinal = VarInt.readVInt(underlyingData, position);
        FlatBlobTypeCache typeCache = this.getTypeCache(typeName);
        T cached = typeCache.get(ordinal);
        if (cached != null) {
            return cached;
        }
        int sizeOfUnderlyingData = VarInt.readVInt(underlyingData, position += (long)VarInt.sizeOfVInt(ordinal));
        FlatBlobDeserializationRecord subRec = this.getDeserializationRecord(typeName);
        subRec.setByteData(rec.getByteData());
        subRec.setCacheElements(rec.shouldCacheElements());
        subRec.position(position += (long)VarInt.sizeOfVInt(sizeOfUnderlyingData));
        Object deserialized = this.framework.getSerializer(typeName).deserialize(subRec);
        if (rec.shouldCacheElements()) {
            deserialized = typeCache.putIfAbsent(ordinal, deserialized);
        }
        return deserialized;
    }

    @Override
    public <T> List<T> deserializeList(FlatBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<T> itemSerializer) {
        int length;
        int numElements;
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        if ((numElements = this.countFlatBlobElementsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length = VarInt.readVInt(byteData, fieldPosition)), length)) == 0) {
            return Collections.emptyList();
        }
        FlatBlobTypeCache<T> typeCache = this.getTypeCache(itemSerializer.getName());
        ListBuilder<T> listBuilder = this.minimizedCollections.createListBuilder();
        listBuilder.builderInit(numElements);
        for (int i = 0; i < numElements; ++i) {
            if (VarInt.readVNull(byteData, fieldPosition)) {
                listBuilder.builderSet(i, null);
                ++fieldPosition;
                continue;
            }
            int ordinal = VarInt.readVInt(byteData, fieldPosition);
            int sizeOfData = VarInt.readVInt(byteData, fieldPosition += (long)VarInt.sizeOfVInt(ordinal));
            fieldPosition += (long)VarInt.sizeOfVInt(sizeOfData);
            T cached = typeCache.get(ordinal);
            if (cached != null) {
                listBuilder.builderSet(i, cached);
            } else {
                FlatBlobDeserializationRecord elementRec = this.getDeserializationRecord(itemSerializer.getName());
                elementRec.setByteData(rec.getByteData());
                elementRec.setCacheElements(rec.shouldCacheElements());
                elementRec.position(fieldPosition);
                T deserialized = itemSerializer.deserialize(elementRec);
                if (rec.shouldCacheElements()) {
                    deserialized = typeCache.putIfAbsent(ordinal, deserialized);
                }
                listBuilder.builderSet(i, deserialized);
            }
            fieldPosition += (long)sizeOfData;
        }
        return listBuilder.builderFinish();
    }

    @Override
    public <T> Set<T> deserializeSet(FlatBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<T> itemSerializer) {
        int length;
        int numElements;
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        if ((numElements = this.countFlatBlobSetElementsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length = VarInt.readVInt(byteData, fieldPosition)), length)) == 0) {
            return Collections.emptySet();
        }
        FlatBlobTypeCache<T> typeCache = this.getTypeCache(itemSerializer.getName());
        SetBuilder<T> setBuilder = this.minimizedCollections.createSetBuilder();
        setBuilder.builderInit(numElements);
        int previousOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            if (VarInt.readVNull(byteData, fieldPosition) && VarInt.readVNull(byteData, fieldPosition + 1L)) {
                setBuilder.builderSet(i, null);
                ++fieldPosition;
                continue;
            }
            int ordinal = -1;
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                ordinal = VarInt.readVInt(byteData, fieldPosition);
                fieldPosition += (long)VarInt.sizeOfVInt(ordinal);
                previousOrdinal = ordinal += previousOrdinal;
            }
            int sizeOfData = VarInt.readVInt(byteData, fieldPosition);
            fieldPosition += (long)VarInt.sizeOfVInt(sizeOfData);
            T cached = typeCache.get(ordinal);
            if (cached != null) {
                setBuilder.builderSet(ordinal, cached);
                fieldPosition += (long)sizeOfData;
                continue;
            }
            FlatBlobDeserializationRecord elementRec = this.getDeserializationRecord(itemSerializer.getName());
            elementRec.setByteData(rec.getByteData());
            elementRec.setCacheElements(rec.shouldCacheElements());
            elementRec.position(fieldPosition);
            T deserialized = itemSerializer.deserialize(elementRec);
            if (rec.shouldCacheElements()) {
                deserialized = typeCache.putIfAbsent(ordinal, deserialized);
            }
            setBuilder.builderSet(i, deserialized);
            fieldPosition += (long)sizeOfData;
        }
        return setBuilder.builderFinish();
    }

    @Override
    public <K, V> Map<K, V> deserializeMap(FlatBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        int numElements = this.countFlatBlobElementsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
        if ((numElements /= 2) == 0) {
            return Collections.emptyMap();
        }
        MapBuilder map = this.minimizedCollections.createMapBuilder();
        map.builderInit(numElements);
        FlatBlobTypeCache keyCache = this.getTypeCache(keySerializer.getName());
        FlatBlobTypeCache valueCache = this.getTypeCache(valueSerializer.getName());
        this.populateMap(byteData, fieldPosition, numElements, map, keySerializer, keyCache, valueSerializer, valueCache, rec.shouldCacheElements());
        return this.minimizedCollections.minimizeMap(map.builderFinish());
    }

    @Override
    public <K, V> SortedMap<K, V> deserializeSortedMap(FlatBlobDeserializationRecord rec, String fieldName, NFTypeSerializer<K> keySerializer, NFTypeSerializer<V> valueSerializer) {
        ByteData byteData = rec.getByteData();
        long fieldPosition = rec.getPosition(fieldName);
        if (fieldPosition == -1L || VarInt.readVNull(byteData, fieldPosition)) {
            return null;
        }
        int length = VarInt.readVInt(byteData, fieldPosition);
        int numElements = this.countFlatBlobElementsInRange(byteData, fieldPosition += (long)VarInt.sizeOfVInt(length), length);
        if ((numElements /= 2) == 0) {
            return this.minimizedCollections.emptySortedMap();
        }
        MapBuilder map = this.minimizedCollections.createSortedMapBuilder();
        map.builderInit(numElements);
        FlatBlobTypeCache keyCache = this.getTypeCache(keySerializer.getName());
        FlatBlobTypeCache valueCache = this.getTypeCache(valueSerializer.getName());
        this.populateMap(byteData, fieldPosition, numElements, map, keySerializer, keyCache, valueSerializer, valueCache, rec.shouldCacheElements());
        return this.minimizedCollections.minimizeSortedMap((SortedMap)map.builderFinish());
    }

    private <K, V> void populateMap(ByteData byteData, long fieldPosition, int numElements, MapBuilder<K, V> mapToPopulate, NFTypeSerializer<K> keySerializer, FlatBlobTypeCache<K> keyCache, NFTypeSerializer<V> valueSerializer, FlatBlobTypeCache<V> valueCache, boolean shouldCacheElements) {
        int previousValueOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            FlatBlobDeserializationRecord rec;
            int sizeOfData;
            Object key = null;
            Object value = null;
            boolean undefinedKeyOrValue = false;
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                int keyOrdinal = VarInt.readVInt(byteData, fieldPosition);
                sizeOfData = VarInt.readVInt(byteData, fieldPosition += (long)VarInt.sizeOfVInt(keyOrdinal));
                fieldPosition += (long)VarInt.sizeOfVInt(sizeOfData);
                key = keyCache.get(keyOrdinal);
                if (key == null) {
                    rec = this.getDeserializationRecord(keyCache.getName());
                    rec.setByteData(byteData);
                    rec.setCacheElements(shouldCacheElements);
                    rec.position(fieldPosition);
                    key = keySerializer.deserialize(rec);
                    if (shouldCacheElements) {
                        key = keyCache.putIfAbsent(keyOrdinal, key);
                    }
                }
                fieldPosition += (long)sizeOfData;
                if (key == null) {
                    undefinedKeyOrValue = true;
                }
            }
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                int valueOrdinal = VarInt.readVInt(byteData, fieldPosition);
                sizeOfData = VarInt.readVInt(byteData, fieldPosition += (long)VarInt.sizeOfVInt(valueOrdinal));
                fieldPosition += (long)VarInt.sizeOfVInt(sizeOfData);
                previousValueOrdinal = valueOrdinal += previousValueOrdinal;
                value = valueCache.get(valueOrdinal);
                if (value == null) {
                    rec = this.getDeserializationRecord(valueCache.getName());
                    rec.setByteData(byteData);
                    rec.setCacheElements(shouldCacheElements);
                    rec.position(fieldPosition);
                    value = valueSerializer.deserialize(rec);
                    if (shouldCacheElements) {
                        value = valueCache.putIfAbsent(valueOrdinal, value);
                    }
                }
                fieldPosition += (long)sizeOfData;
                if (value == null) {
                    undefinedKeyOrValue = true;
                }
            }
            if (undefinedKeyOrValue) continue;
            mapToPopulate.builderPut(i, key, value);
        }
    }

    private int countFlatBlobSetElementsInRange(ByteData byteData, long fieldPosition, int length) {
        int numElements = 0;
        long endPosition = (long)length + fieldPosition;
        while (fieldPosition < endPosition) {
            if (VarInt.readVNull(byteData, fieldPosition) && VarInt.readVNull(byteData, fieldPosition + 1L)) {
                fieldPosition += 2L;
            } else {
                if (VarInt.readVNull(byteData, fieldPosition)) {
                    ++fieldPosition;
                } else {
                    int ordinal = VarInt.readVInt(byteData, fieldPosition);
                    fieldPosition += (long)VarInt.sizeOfVInt(ordinal);
                }
                int eLen = VarInt.readVInt(byteData, fieldPosition);
                fieldPosition += (long)VarInt.sizeOfVInt(eLen);
                fieldPosition += (long)eLen;
            }
            ++numElements;
        }
        return numElements;
    }

    private int countFlatBlobElementsInRange(ByteData byteData, long fieldPosition, int length) {
        int numElements = 0;
        long endPosition = (long)length + fieldPosition;
        while (fieldPosition < endPosition) {
            if (VarInt.readVNull(byteData, fieldPosition)) {
                ++fieldPosition;
            } else {
                int ordinal = VarInt.readVInt(byteData, fieldPosition);
                int eLen = VarInt.readVInt(byteData, fieldPosition += (long)VarInt.sizeOfVInt(ordinal));
                fieldPosition += (long)VarInt.sizeOfVInt(eLen);
                fieldPosition += (long)eLen;
            }
            ++numElements;
        }
        return numElements;
    }

    private String readString(ByteData data, long position, int length) {
        long endPosition = position + (long)length;
        char[] chararr = this.getCharArray(length);
        int count = 0;
        while (position < endPosition) {
            int c = VarInt.readVInt(data, position);
            chararr[count++] = (char)c;
            position += (long)VarInt.sizeOfVInt(c);
        }
        return new String(chararr, 0, count);
    }

    private char[] getCharArray(int length) {
        char[] ch;
        if (length < 100) {
            length = 100;
        }
        if ((ch = this.chararr.get()) == null || ch.length < length) {
            ch = new char[length];
            this.chararr.set(ch);
        }
        return ch;
    }

    FlatBlobDeserializationRecord getDeserializationRecord(String type) {
        FlatBlobDeserializationRecord rec;
        Map<String, FlatBlobDeserializationRecord> map = this.deserializationRecords.get();
        if (map == null) {
            map = new HashMap<String, FlatBlobDeserializationRecord>();
            this.deserializationRecords.set(map);
        }
        if ((rec = map.get(type)) == null) {
            FastBlobSchema schema = this.framework.getSerializer(type).getFastBlobSchema();
            rec = new FlatBlobDeserializationRecord(schema);
            map.put(type, rec);
        }
        return rec;
    }

    <T> FlatBlobTypeCache<T> getTypeCache(String type) {
        return this.typeCaches.get(type);
    }
}

