/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.state.FastBlobTypeDeserializationState;
import com.netflix.zeno.flatblob.FlatBlobSerializationFramework;
import com.netflix.zeno.flatblob.FlatBlobSerializationRecord;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FlatBlobFrameworkSerializer
extends FrameworkSerializer<FlatBlobSerializationRecord> {
    static final int NULL_FLOAT_BITS = Float.floatToIntBits(Float.NaN) + 1;
    static final long NULL_DOUBLE_BITS = Double.doubleToLongBits(Double.NaN) + 1L;
    private final FastBlobStateEngine stateEngine;
    private final ThreadLocal<Map<String, FlatBlobSerializationRecord>> cachedSerializationRecords;

    public FlatBlobFrameworkSerializer(FlatBlobSerializationFramework flatBlobFramework, FastBlobStateEngine stateEngine) {
        super(flatBlobFramework);
        this.stateEngine = stateEngine;
        this.cachedSerializationRecords = new ThreadLocal();
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Integer) {
            this.serializePrimitive(rec, fieldName, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.serializePrimitive(rec, fieldName, (long)((Long)value));
        } else if (value instanceof Float) {
            this.serializePrimitive(rec, fieldName, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.serializePrimitive(rec, fieldName, (double)((Double)value));
        } else if (value instanceof Boolean) {
            this.serializePrimitive(rec, fieldName, (boolean)((Boolean)value));
        } else if (value instanceof String) {
            this.serializeString(rec, fieldName, (String)value);
        } else if (value instanceof byte[]) {
            this.serializeBytes(rec, fieldName, (byte[])value);
        } else {
            throw new RuntimeException("Primitive type " + value.getClass().getSimpleName() + " not supported!");
        }
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, int value) {
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        VarInt.writeVInt(fieldBuffer, value << 1 ^ value >> 31);
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, long value) {
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        VarInt.writeVLong(fieldBuffer, value << 1 ^ value >> 63);
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, float value) {
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        int intBits = Float.floatToIntBits(value);
        FlatBlobFrameworkSerializer.writeFixedLengthInt(fieldBuffer, intBits);
    }

    private static void writeFixedLengthInt(ByteDataBuffer fieldBuffer, int intBits) {
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, double value) {
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        long intBits = Double.doubleToLongBits(value);
        FlatBlobFrameworkSerializer.writeFixedLengthLong(fieldBuffer, intBits);
    }

    private static void writeFixedLengthLong(ByteDataBuffer fieldBuffer, long intBits) {
        fieldBuffer.write((byte)(intBits >>> 56));
        fieldBuffer.write((byte)(intBits >>> 48));
        fieldBuffer.write((byte)(intBits >>> 40));
        fieldBuffer.write((byte)(intBits >>> 32));
        fieldBuffer.write((byte)(intBits >>> 24));
        fieldBuffer.write((byte)(intBits >>> 16));
        fieldBuffer.write((byte)(intBits >>> 8));
        fieldBuffer.write((byte)intBits);
    }

    @Override
    public void serializePrimitive(FlatBlobSerializationRecord rec, String fieldName, boolean value) {
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        byte byteValue = value ? (byte)1 : 0;
        fieldBuffer.write(byteValue);
    }

    private void serializeString(FlatBlobSerializationRecord rec, String fieldName, String value) {
        if (value == null) {
            return;
        }
        this.writeString(value, rec.getFieldBuffer(fieldName));
    }

    @Override
    public void serializeBytes(FlatBlobSerializationRecord rec, String fieldName, byte[] value) {
        if (value == null) {
            return;
        }
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldName);
        for (int i = 0; i < value.length; ++i) {
            fieldBuffer.write(value[i]);
        }
    }

    @Override
    @Deprecated
    public void serializeObject(FlatBlobSerializationRecord rec, String fieldName, String typeName, Object obj) {
        int fieldPosition = rec.getSchema().getPosition(fieldName);
        this.validateField(fieldName, fieldPosition);
        this.serializeObject(rec, fieldPosition, typeName, obj);
    }

    private void validateField(String fieldName, int fieldPosition) {
        if (fieldPosition == -1) {
            throw new IllegalArgumentException("Attempting to serialize non existent field " + fieldName + ".");
        }
    }

    private void serializeObject(FlatBlobSerializationRecord rec, int fieldPosition, String typeName, Object obj) {
        if (obj == null) {
            return;
        }
        int ordinal = this.findOrdinalInStateEngine(typeName, obj);
        FlatBlobSerializationRecord subRecord = this.getSerializationRecord(typeName);
        this.framework.getSerializer(typeName).serialize(obj, subRecord);
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldPosition);
        VarInt.writeVInt(fieldBuffer, ordinal);
        VarInt.writeVInt(fieldBuffer, subRecord.sizeOfData());
        subRecord.writeDataTo(fieldBuffer);
    }

    @Override
    public void serializeObject(FlatBlobSerializationRecord rec, String fieldName, Object obj) {
        int fieldPosition = rec.getSchema().getPosition(fieldName);
        this.validateField(fieldName, fieldPosition);
        this.serializeObject(rec, fieldPosition, rec.getSchema().getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(FlatBlobSerializationRecord rec, String fieldName, String typeName, Collection<T> obj) {
        if (obj == null) {
            return;
        }
        NFTypeSerializer<T> elementSerializer = this.framework.getSerializer(typeName);
        int fieldPosition = rec.getSchema().getPosition(fieldName);
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldPosition);
        FlatBlobSerializationRecord subRecord = this.getSerializationRecord(typeName);
        for (T t : obj) {
            if (t == null) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            int ordinal = this.findOrdinalInStateEngine(typeName, t);
            elementSerializer.serialize(t, subRecord);
            VarInt.writeVInt(fieldBuffer, ordinal);
            VarInt.writeVInt(fieldBuffer, subRecord.sizeOfData());
            subRecord.writeDataTo(fieldBuffer);
            subRecord.reset();
        }
    }

    @Override
    public <T> void serializeSet(FlatBlobSerializationRecord rec, String fieldName, String typeName, Set<T> set) {
        if (set == null) {
            return;
        }
        FastBlobTypeDeserializationState<T> typeDeserializationState = this.stateEngine.getTypeDeserializationState(typeName);
        int fieldPosition = rec.getSchema().getPosition(fieldName);
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldPosition);
        int[] setOrdinals = new int[set.size()];
        Object[] unidentifiedSetObjects = null;
        int i = 0;
        for (T obj : set) {
            if (obj == null) {
                setOrdinals[i++] = -1;
                continue;
            }
            setOrdinals[i] = typeDeserializationState.find(obj);
            if (setOrdinals[i] == -1) {
                if (unidentifiedSetObjects == null) {
                    unidentifiedSetObjects = new Object[set.size()];
                }
                unidentifiedSetObjects[i] = obj;
                setOrdinals[i] = Integer.MIN_VALUE;
            }
            ++i;
        }
        Arrays.sort(setOrdinals);
        FlatBlobSerializationRecord subRecord = this.getSerializationRecord(typeName);
        int currentOrdinal = 0;
        for (i = 0; i < setOrdinals.length; ++i) {
            Object element;
            if (setOrdinals[i] == -1) {
                VarInt.writeVNull(fieldBuffer);
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            if (setOrdinals[i] == Integer.MIN_VALUE) {
                element = unidentifiedSetObjects[i];
                this.framework.getSerializer(typeName).serialize(element, subRecord);
                VarInt.writeVNull(fieldBuffer);
            } else {
                element = typeDeserializationState.get(setOrdinals[i]);
                this.framework.getSerializer(typeName).serialize(element, subRecord);
                VarInt.writeVInt(fieldBuffer, setOrdinals[i] - currentOrdinal);
                currentOrdinal = setOrdinals[i];
            }
            VarInt.writeVInt(fieldBuffer, subRecord.sizeOfData());
            subRecord.writeDataTo(fieldBuffer);
            subRecord.reset();
        }
    }

    @Override
    public <K, V> void serializeMap(FlatBlobSerializationRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> map) {
        if (map == null) {
            return;
        }
        FastBlobTypeDeserializationState<K> keyDeserializationState = this.stateEngine.getTypeDeserializationState(keyTypeName);
        FastBlobTypeDeserializationState<V> valueDeserializationState = this.stateEngine.getTypeDeserializationState(valueTypeName);
        int fieldPosition = rec.getSchema().getPosition(fieldName);
        ByteDataBuffer fieldBuffer = rec.getFieldBuffer(fieldPosition);
        FlatBlobSerializationRecord keyRecord = this.getSerializationRecord(keyTypeName);
        FlatBlobSerializationRecord valueRecord = this.getSerializationRecord(valueTypeName);
        long[] mapEntries = new long[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int keyOrdinal = -1;
            int valueOrdinal = -1;
            if (entry.getKey() != null) {
                keyOrdinal = keyDeserializationState.find(entry.getKey());
            }
            if (entry.getValue() != null) {
                valueOrdinal = valueDeserializationState.find(entry.getValue());
            }
            mapEntries[i++] = (long)valueOrdinal << 32 | (long)keyOrdinal & 0xFFFFFFFFL;
        }
        if (mapEntries.length > i) {
            mapEntries = Arrays.copyOf(mapEntries, i);
            throw new RuntimeException("This should not happen.");
        }
        Arrays.sort(mapEntries);
        int currentValueOrdinal = 0;
        for (i = 0; i < mapEntries.length; ++i) {
            int keyOrdinal = (int)mapEntries[i];
            int valueOrdinal = (int)(mapEntries[i] >> 32);
            if (keyOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
            } else {
                Object key = keyDeserializationState.get(keyOrdinal);
                keyRecord.reset();
                this.framework.getSerializer(keyTypeName).serialize(key, keyRecord);
                VarInt.writeVInt(fieldBuffer, keyOrdinal);
                VarInt.writeVInt(fieldBuffer, keyRecord.sizeOfData());
                keyRecord.writeDataTo(fieldBuffer);
            }
            if (valueOrdinal == -1) {
                VarInt.writeVNull(fieldBuffer);
                continue;
            }
            Object value = valueDeserializationState.get(valueOrdinal);
            valueRecord.reset();
            this.framework.getSerializer(valueTypeName).serialize(value, valueRecord);
            VarInt.writeVInt(fieldBuffer, valueOrdinal - currentValueOrdinal);
            VarInt.writeVInt(fieldBuffer, valueRecord.sizeOfData());
            valueRecord.writeDataTo(fieldBuffer);
            currentValueOrdinal = valueOrdinal;
        }
    }

    private void writeString(String str, ByteDataBuffer out) {
        for (int i = 0; i < str.length(); ++i) {
            VarInt.writeVInt(out, (int)str.charAt(i));
        }
    }

    private int findOrdinalInStateEngine(String typeName, Object obj) {
        FastBlobTypeDeserializationState<Object> typeDeserializationState = this.stateEngine.getTypeDeserializationState(typeName);
        int ordinal = typeDeserializationState.find(obj);
        return ordinal;
    }

    FlatBlobSerializationRecord getSerializationRecord(String type) {
        FlatBlobSerializationRecord rec;
        Map<String, FlatBlobSerializationRecord> cachedSerializationRecords = this.cachedSerializationRecords.get();
        if (cachedSerializationRecords == null) {
            cachedSerializationRecords = new HashMap<String, FlatBlobSerializationRecord>();
            this.cachedSerializationRecords.set(cachedSerializationRecords);
        }
        if ((rec = cachedSerializationRecords.get(type)) == null) {
            rec = new FlatBlobSerializationRecord(this.framework.getSerializer(type).getFastBlobSchema());
            cachedSerializationRecords.put(type, rec);
        }
        rec.reset();
        return rec;
    }
}

