/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.fastblob.record.ByteData;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.flatblob.FlatBlobDeserializationRecord;
import com.netflix.zeno.flatblob.FlatBlobFrameworkDeserializer;
import com.netflix.zeno.flatblob.FlatBlobFrameworkSerializer;
import com.netflix.zeno.flatblob.FlatBlobSerializationRecord;
import com.netflix.zeno.flatblob.FlatBlobTypeCache;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.SerializerFactory;

public class FlatBlobSerializationFramework
extends SerializationFramework {
    FastBlobStateEngine stateEngine;

    public FlatBlobSerializationFramework(SerializerFactory serializerFactory) {
        this(serializerFactory, null);
    }

    public FlatBlobSerializationFramework(SerializerFactory serializerFactory, FastBlobStateEngine readDeserializedObjectsFrom) {
        super(serializerFactory);
        this.stateEngine = readDeserializedObjectsFrom;
        this.frameworkSerializer = new FlatBlobFrameworkSerializer(this, this.stateEngine);
        this.frameworkDeserializer = new FlatBlobFrameworkDeserializer(this);
        if (this.stateEngine != null) {
            for (String serializerName : this.stateEngine.getSerializerNames()) {
                this.stateEngine.getTypeDeserializationState(serializerName).createIdentityOrdinalMap();
            }
        }
    }

    public void serialize(String type, Object obj, ByteDataBuffer os) {
        FlatBlobSerializationRecord rec = ((FlatBlobFrameworkSerializer)this.frameworkSerializer).getSerializationRecord(type);
        this.getSerializer(type).serialize(obj, rec);
        rec.writeDataTo(os);
    }

    public <T> T deserialize(String type, ByteData data, boolean cacheElements) {
        return this.deserialize(type, data, 0, cacheElements);
    }

    public <T> T deserialize(String type, ByteData data, int position, boolean cacheElements) {
        FlatBlobDeserializationRecord rec = ((FlatBlobFrameworkDeserializer)this.frameworkDeserializer).getDeserializationRecord(type);
        rec.setCacheElements(cacheElements);
        rec.setByteData(data);
        rec.position(position);
        return this.getSerializer(type).deserialize(rec);
    }

    public <T> T getCached(String type, int ordinal) {
        FlatBlobTypeCache typeCache = ((FlatBlobFrameworkDeserializer)this.frameworkDeserializer).getTypeCache(type);
        return typeCache.get(ordinal);
    }

    <T> FlatBlobTypeCache<T> getTypeCache(String type) {
        return ((FlatBlobFrameworkDeserializer)this.frameworkDeserializer).getTypeCache(type);
    }
}

