/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import com.netflix.zeno.fastblob.FastBlobFrameworkSerializer;
import com.netflix.zeno.fastblob.record.ByteDataBuffer;
import com.netflix.zeno.fastblob.record.VarInt;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFSerializationRecord;

public class FlatBlobSerializationRecord
extends NFSerializationRecord {
    private final ByteDataBuffer[] fieldData;
    private final boolean[] isNonNull;

    public FlatBlobSerializationRecord(FastBlobSchema schema) {
        this.fieldData = new ByteDataBuffer[schema.numFields()];
        this.isNonNull = new boolean[schema.numFields()];
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.fieldData[i] = new ByteDataBuffer(32);
        }
        this.setSchema(schema);
    }

    public ByteDataBuffer getFieldBuffer(String field) {
        int fieldPosition = this.getSchema().getPosition(field);
        return this.getFieldBuffer(fieldPosition);
    }

    public ByteDataBuffer getFieldBuffer(int fieldPosition) {
        this.isNonNull[fieldPosition] = true;
        this.fieldData[fieldPosition].reset();
        return this.fieldData[fieldPosition];
    }

    public void writeDataTo(ByteDataBuffer buf) {
        for (int i = 0; i < this.fieldData.length; ++i) {
            FastBlobSchema.FieldType fieldType = this.getSchema().getFieldType(i);
            if (this.isNonNull[i]) {
                if (fieldType.startsWithVarIntEncodedLength()) {
                    VarInt.writeVInt(buf, (int)this.fieldData[i].length());
                }
                this.fieldData[i].copyTo(buf);
                continue;
            }
            if (fieldType == FastBlobSchema.FieldType.FLOAT) {
                FastBlobFrameworkSerializer.writeNullFloat(buf);
                continue;
            }
            if (fieldType == FastBlobSchema.FieldType.DOUBLE) {
                FastBlobFrameworkSerializer.writeNullDouble(buf);
                continue;
            }
            VarInt.writeVNull(buf);
        }
    }

    public int sizeOfData() {
        int dataSize = 0;
        for (int i = 0; i < this.fieldData.length; ++i) {
            FastBlobSchema.FieldType fieldType = this.getSchema().getFieldType(i);
            if (this.isNonNull[i]) {
                if (fieldType.startsWithVarIntEncodedLength()) {
                    dataSize += VarInt.sizeOfVInt((int)this.fieldData[i].length());
                }
                dataSize = (int)((long)dataSize + this.fieldData[i].length());
                continue;
            }
            if (fieldType == FastBlobSchema.FieldType.FLOAT) {
                dataSize += 4;
                continue;
            }
            if (fieldType == FastBlobSchema.FieldType.DOUBLE) {
                dataSize += 8;
                continue;
            }
            ++dataSize;
        }
        return dataSize;
    }

    public void reset() {
        for (int i = 0; i < this.fieldData.length; ++i) {
            this.isNonNull[i] = false;
        }
    }
}

