/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.flatblob;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FlatBlobTypeCache<T> {
    private final String name;
    private final ConcurrentHashMap<Integer, ObjectIdentityKey> references;
    private final ConcurrentHashMap<ObjectIdentityKey, Integer> ordinalLookup;
    private static ThreadLocal<ObjectIdentityKey> lookupKey = new ThreadLocal();

    public FlatBlobTypeCache(String name) {
        this.name = name;
        this.references = new ConcurrentHashMap();
        this.ordinalLookup = new ConcurrentHashMap();
    }

    public String getName() {
        return this.name;
    }

    public T putIfAbsent(int ordinal, T obj) {
        if (ordinal >= 0) {
            Integer ordinalInteger = ordinal;
            ObjectIdentityKey key = new ObjectIdentityKey(obj);
            block0: while (true) {
                ObjectIdentityKey existingKey;
                if ((existingKey = this.references.putIfAbsent(ordinalInteger, key)) == null) {
                    this.ordinalLookup.put(key, ordinalInteger);
                    return obj;
                }
                if (existingKey.tryIncrementReferences()) {
                    return (T)existingKey.getObject();
                }
                key.setObject(existingKey.getObject());
                while (true) {
                    if (this.references.get(ordinalInteger) != existingKey) continue block0;
                }
                break;
            }
        }
        return obj;
    }

    public void evict(T obj) {
        Integer ordinalInteger;
        ObjectIdentityKey actualKey;
        ObjectIdentityKey lookupKey = this.getLookupKey(obj);
        if (lookupKey != null && (actualKey = this.references.get(ordinalInteger = this.ordinalLookup.get(lookupKey))).decrementReferences()) {
            this.ordinalLookup.remove(actualKey);
            this.references.remove(ordinalInteger);
        }
    }

    public T get(int ordinal) {
        if (ordinal < 0) {
            return null;
        }
        ObjectIdentityKey identityKey = this.references.get(ordinal);
        if (identityKey != null && identityKey.tryIncrementReferences()) {
            return (T)identityKey.getObject();
        }
        return null;
    }

    private ObjectIdentityKey getLookupKey(Object obj) {
        ObjectIdentityKey key = lookupKey.get();
        if (key == null) {
            key = new ObjectIdentityKey();
            lookupKey.set(key);
        }
        key.setObject(obj);
        return key;
    }

    private static class ObjectIdentityKey {
        private Object obj;
        private final AtomicInteger referenceCount;

        public ObjectIdentityKey() {
            this.referenceCount = new AtomicInteger(0);
        }

        public ObjectIdentityKey(Object obj) {
            this.obj = obj;
            this.referenceCount = new AtomicInteger(1);
        }

        public Object getObject() {
            return this.obj;
        }

        public void setObject(Object obj) {
            this.obj = obj;
        }

        public boolean tryIncrementReferences() {
            int next;
            int current;
            do {
                if ((current = this.referenceCount.get()) != 0) continue;
                return false;
            } while (!this.referenceCount.compareAndSet(current, next = current + 1));
            return true;
        }

        public boolean decrementReferences() {
            return this.referenceCount.decrementAndGet() == 0;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object other) {
            if (other instanceof ObjectIdentityKey) {
                return this.obj == ((ObjectIdentityKey)other).getObject();
            }
            return false;
        }
    }
}

