/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.genericobject;

import com.netflix.zeno.diff.DiffRecord;
import com.netflix.zeno.diff.DiffSerializationFramework;
import com.netflix.zeno.genericobject.GenericObject;
import com.netflix.zeno.genericobject.JaccardMatrixPairwiseMatcher;
import com.netflix.zeno.serializer.SerializerFactory;
import java.util.ArrayList;
import java.util.List;

public class DiffHtmlCollectionLocker {
    private final DiffSerializationFramework diffFramework;

    public DiffHtmlCollectionLocker(SerializerFactory factory) {
        this.diffFramework = new DiffSerializationFramework(factory);
    }

    void lockCollectionFields(GenericObject from, GenericObject to) {
        ArrayList<GenericObject.Field> lockedFromFields = new ArrayList<GenericObject.Field>();
        ArrayList<GenericObject.Field> lockedToFields = new ArrayList<GenericObject.Field>();
        List<DiffRecord> fromDiffRecords = this.createDiffRecordList(from);
        List<DiffRecord> toDiffRecords = this.createDiffRecordList(to);
        JaccardMatrixPairwiseMatcher matcher = new JaccardMatrixPairwiseMatcher(from.getFields(), fromDiffRecords, to.getFields(), toDiffRecords);
        while (matcher.nextPair()) {
            lockedFromFields.add(matcher.getX());
            lockedToFields.add(matcher.getY());
        }
        from.setFields(lockedFromFields);
        to.setFields(lockedToFields);
    }

    private List<DiffRecord> createDiffRecordList(GenericObject from) {
        ArrayList<DiffRecord> diffRecords = new ArrayList<DiffRecord>();
        for (int i = 0; i < from.getFields().size(); ++i) {
            DiffRecord rec;
            GenericObject.Field field = from.getFields().get(i);
            if (field != null && field.getValue() != null) {
                rec = this.getDiffRecord(field);
                diffRecords.add(rec);
                continue;
            }
            rec = new DiffRecord();
            rec.setSchema(from.getSchema());
            diffRecords.add(rec);
        }
        return diffRecords;
    }

    private DiffRecord getDiffRecord(GenericObject.Field field) {
        GenericObject fieldValue = (GenericObject)field.getValue();
        DiffRecord rec = new DiffRecord();
        rec.setSchema(fieldValue.getSchema());
        if (field.getValue() instanceof GenericObject) {
            rec.setTopLevelSerializerName(fieldValue.getObjectType());
            this.diffFramework.getSerializer(fieldValue.getObjectType()).serialize(fieldValue.getActualObject(), rec);
        } else {
            rec.setTopLevelSerializerName("primitive");
            rec.serializePrimitive("value", field.getValue());
        }
        return rec;
    }
}

