/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.genericobject;

import com.netflix.zeno.genericobject.DiffHtmlCollectionLocker;
import com.netflix.zeno.genericobject.GenericObject;
import com.netflix.zeno.genericobject.GenericObjectSerializationFramework;
import com.netflix.zeno.serializer.SerializerFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffHtmlGenerator {
    private final DiffHtmlCollectionLocker locker;
    private final GenericObjectSerializationFramework genericObjectFramework;
    private final boolean[] moreAtFromLevels = new boolean[1024];
    private final boolean[] moreAtToLevels = new boolean[1024];
    private int hierarchyLevel = 1;
    private static final Comparator<GenericObject.Field> mapFieldComparator = new Comparator<GenericObject.Field>(){

        @Override
        public int compare(GenericObject.Field o1, GenericObject.Field o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Object key1 = DiffHtmlGenerator.getKey(o1);
            Object key2 = DiffHtmlGenerator.getKey(o2);
            if (key1 instanceof Comparable) {
                return ((Comparable)key1).compareTo(key2);
            }
            return key1.hashCode() - key2.hashCode();
        }
    };

    public DiffHtmlGenerator(SerializerFactory factory) {
        this.locker = new DiffHtmlCollectionLocker(factory);
        this.genericObjectFramework = new GenericObjectSerializationFramework(factory);
    }

    public String generateDiff(String objectType, Object from, Object to) {
        GenericObject fromGenericObject = from == null ? null : this.genericObjectFramework.serialize(from, objectType);
        GenericObject toGenericObject = to == null ? null : this.genericObjectFramework.serialize(to, objectType);
        return this.generateDiff(fromGenericObject, toGenericObject);
    }

    public String generateDiff(GenericObject from, GenericObject to) {
        StringBuilder builder = new StringBuilder();
        builder.append("<table class=\"nomargin diff\">");
        builder.append("<thead>");
        builder.append("<tr>");
        builder.append("<th/>");
        builder.append("<th class=\"texttitle\">From</th>");
        builder.append("<th/>");
        builder.append("<th class=\"texttitle\">To</th>");
        builder.append("</tr>");
        builder.append("</thead>");
        builder.append("<tbody>");
        this.writeDiff(builder, from, to);
        builder.append("</tbody>");
        builder.append("</table>");
        return builder.toString();
    }

    private void writeDiff(StringBuilder builder, GenericObject from, GenericObject to) {
        if (from != null && to != null) {
            this.writeDiffBothObjectsPresent(builder, from, to);
        } else if (from != null || to != null) {
            this.writeDiffOneObjectNull(builder, from, to);
        }
    }

    private void writeDiffBothObjectsPresent(StringBuilder builder, GenericObject from, GenericObject to) {
        if (from.getCollectionType() == GenericObject.CollectionType.COLLECTION) {
            this.writeCollectionDiff(builder, from, to);
        } else if (from.getCollectionType() == GenericObject.CollectionType.MAP) {
            this.writeMapDiff(builder, from, to);
        } else {
            this.writeObjectDiff(builder, from, to);
        }
    }

    private void writeCollectionDiff(StringBuilder builder, GenericObject from, GenericObject to) {
        this.locker.lockCollectionFields(from, to);
        for (int i = 0; i < from.getFields().size(); ++i) {
            GenericObject.Field fromField = from.getFields().get(i);
            GenericObject.Field toField = to.getFields().get(i);
            boolean moreFromFields = this.moreCollectionFields(from.getFields(), i);
            boolean moreToFields = this.moreCollectionFields(to.getFields(), i);
            this.appendField(builder, fromField, toField, moreFromFields, moreToFields);
        }
    }

    private void writeMapDiff(StringBuilder builder, GenericObject from, GenericObject to) {
        this.sortMapFieldsByKey(from);
        this.sortMapFieldsByKey(to);
        int fromCounter = 0;
        int toCounter = 0;
        while (fromCounter < from.getFields().size() || toCounter < to.getFields().size()) {
            GenericObject.Field fromField = fromCounter < from.getFields().size() ? from.getFields().get(fromCounter) : null;
            GenericObject.Field toField = toCounter < to.getFields().size() ? to.getFields().get(toCounter) : null;
            int comparison = mapFieldComparator.compare(fromField, toField);
            boolean moreFromFields = this.moreCollectionFields(from.getFields(), fromCounter);
            boolean moreToFields = this.moreCollectionFields(to.getFields(), toCounter);
            if (comparison == 0) {
                this.appendField(builder, fromField, toField, moreFromFields, moreToFields);
                ++fromCounter;
                ++toCounter;
                continue;
            }
            if (comparison < 0) {
                this.appendField(builder, fromField, null, moreFromFields, toField != null);
                ++fromCounter;
                continue;
            }
            this.appendField(builder, null, toField, fromField != null, moreToFields);
            ++toCounter;
        }
    }

    private boolean moreCollectionFields(List<GenericObject.Field> fieldList, int position) {
        if (position >= fieldList.size()) {
            return false;
        }
        for (int i = position + 1; i < fieldList.size(); ++i) {
            if (fieldList.get(i) == null) continue;
            return true;
        }
        return false;
    }

    private void writeObjectDiff(StringBuilder builder, GenericObject from, GenericObject to) {
        for (int i = 0; i < from.getFields().size(); ++i) {
            GenericObject.Field fromField = from.getFields().get(i);
            GenericObject.Field toField = to.getFields().get(i);
            boolean moreFields = i != from.getFields().size() - 1;
            this.appendField(builder, fromField, toField, moreFields, moreFields);
        }
    }

    private void sortMapFieldsByKey(GenericObject map) {
        Collections.sort(map.getFields(), mapFieldComparator);
    }

    private void writeDiffOneObjectNull(StringBuilder builder, GenericObject from, GenericObject to) {
        if (from != null) {
            for (int i = 0; i < from.getFields().size(); ++i) {
                boolean moreFields = i != from.getFields().size() - 1;
                this.appendField(builder, from.getFields().get(i), null, moreFields, false);
            }
        } else {
            for (int i = 0; i < to.getFields().size(); ++i) {
                boolean moreFields = i != to.getFields().size() - 1;
                this.appendField(builder, null, to.getFields().get(i), false, moreFields);
            }
        }
    }

    private void appendField(StringBuilder builder, GenericObject.Field fromField, GenericObject.Field toField, boolean moreAtFromLevel, boolean moreAtToLevel) {
        this.moreAtFromLevels[this.hierarchyLevel] = moreAtFromLevel;
        this.moreAtToLevels[this.hierarchyLevel] = moreAtToLevel;
        Object nonNullValue = this.getNonNullValue(fromField, toField);
        builder.append("<tr>");
        if (fromField != null && fromField.getCollectionPosition() != 0) {
            builder.append("<th>").append(fromField.getCollectionPosition()).append("</th>");
        } else {
            builder.append("<th/>");
        }
        builder.append("<td class=\"").append(this.cssClass(fromField, toField, "delete")).append("\">");
        if (fromField != null) {
            if (nonNullValue instanceof GenericObject) {
                this.openNewObject(builder, fromField.getFieldName(), ((GenericObject)nonNullValue).getObjectType(), moreAtFromLevel, true);
            } else {
                this.appendFieldValue(builder, fromField.getFieldName(), fromField.getValue(), moreAtFromLevel, true);
            }
        } else {
            this.appendEmptyHierarchyLevel(builder, this.moreAtFromLevels);
        }
        builder.append("</td>");
        if (toField != null && toField.getCollectionPosition() != 0) {
            builder.append("<th>").append(toField.getCollectionPosition()).append("</th>");
        } else {
            builder.append("<th/>");
        }
        builder.append("<td class=\"").append(this.cssClass(toField, fromField, "insert")).append("\">");
        if (toField != null) {
            if (nonNullValue instanceof GenericObject) {
                this.openNewObject(builder, toField.getFieldName(), ((GenericObject)nonNullValue).getObjectType(), moreAtToLevel, false);
            } else {
                this.appendFieldValue(builder, toField.getFieldName(), toField.getValue(), moreAtToLevel, false);
            }
        } else {
            this.appendEmptyHierarchyLevel(builder, this.moreAtToLevels);
        }
        builder.append("</td>");
        builder.append("</tr>");
        if (nonNullValue instanceof GenericObject) {
            ++this.hierarchyLevel;
            this.writeDiff(builder, (GenericObject)this.fieldValue(fromField), (GenericObject)this.fieldValue(toField));
            --this.hierarchyLevel;
        }
        this.moreAtFromLevels[this.hierarchyLevel] = false;
        this.moreAtToLevels[this.hierarchyLevel] = false;
    }

    private Object fieldValue(GenericObject.Field field) {
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    private Object getNonNullValue(GenericObject.Field fromField, GenericObject.Field toField) {
        if (fromField != null && fromField.getValue() != null) {
            return fromField.getValue();
        }
        if (toField != null) {
            return toField.getValue();
        }
        return null;
    }

    private void openNewObject(StringBuilder builder, String fieldName, String typeName, boolean lastFieldAtLevel, boolean from) {
        this.appendHierarchyLevel(builder, true, this.hierarchyLevel, lastFieldAtLevel, from);
        builder.append(fieldName).append(": ").append("(").append(typeName).append(")\n");
    }

    private String cssClass(GenericObject.Field field1, GenericObject.Field field2, String missingCssClass) {
        if (field1 == null) {
            return "empty";
        }
        if (field2 == null) {
            return missingCssClass;
        }
        if (field1.getValue() == null && field2.getValue() != null) {
            return "replace";
        }
        if (field1.getValue() == null && field2.getValue() == null) {
            return "equal";
        }
        if (field1.getValue() != null && field2.getValue() == null) {
            return "replace";
        }
        if (!(field1.getValue() instanceof GenericObject) && !field1.getValue().equals(field2.getValue())) {
            return "replace";
        }
        return "equal";
    }

    private void appendFieldValue(StringBuilder builder, String fieldName, Object value, boolean moreFieldsAtLevel, boolean from) {
        this.appendHierarchyLevel(builder, false, this.hierarchyLevel, moreFieldsAtLevel, from);
        builder.append(fieldName).append(": ").append(value).append("\n");
    }

    private void appendHierarchyLevel(StringBuilder builder, boolean objectField, int hierarchyLevel, boolean moreFieldsAtLevel, boolean from) {
        boolean[] levelGuide = from ? this.moreAtFromLevels : this.moreAtToLevels;
        for (int i = 1; i < hierarchyLevel; ++i) {
            if (levelGuide[i]) {
                builder.append(".&#x2502;");
                continue;
            }
            builder.append("..");
        }
        if (objectField) {
            if (moreFieldsAtLevel) {
                builder.append(".&#x251D;&#x2501;&#x252F;&#x2501;>");
            } else {
                builder.append(".&#x2515;&#x2501;&#x252F;&#x2501;>");
            }
        } else if (moreFieldsAtLevel) {
            builder.append(".&#x251C;&#x2500;&#x2500;&#x2500;>");
        } else {
            builder.append(".&#x2514;&#x2500;&#x2500;&#x2500;>");
        }
    }

    private void appendEmptyHierarchyLevel(StringBuilder builder, boolean[] levelGuide) {
        block0: for (int i = 1; i <= this.hierarchyLevel; ++i) {
            if (levelGuide[i]) {
                builder.append(" &#x2502;");
                continue;
            }
            for (int j = i; j <= this.hierarchyLevel; ++j) {
                if (!levelGuide[j]) continue;
                builder.append("  ");
                continue block0;
            }
        }
    }

    private static Object getKey(GenericObject.Field entryField) {
        GenericObject entryObject = (GenericObject)entryField.getValue();
        GenericObject.Field keyField = entryObject.getFields().get(0);
        GenericObject keyObject = (GenericObject)keyField.getValue();
        return keyObject.getActualObject();
    }
}

