/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.genericobject;

import com.netflix.zeno.serializer.NFSerializationRecord;
import java.util.ArrayList;
import java.util.List;

public class GenericObject
extends NFSerializationRecord {
    private final String type;
    private final CollectionType collectionType;
    private final Object actualObject;
    private int collectionPosition;
    private List<Field> fields;

    public GenericObject(String objectType, Object actualObject) {
        this(objectType, CollectionType.NONE, actualObject);
    }

    public GenericObject(String objectType, CollectionType collectionType, Object actualObject) {
        this.type = objectType;
        this.collectionType = collectionType;
        this.actualObject = actualObject;
        this.fields = new ArrayList<Field>();
    }

    public void setCollectionPosition(int position) {
        this.collectionPosition = position;
    }

    public int getCollectionPosition() {
        return this.collectionPosition;
    }

    public void add(String fieldName, Object obj) {
        this.fields.add(new Field(fieldName, obj));
    }

    public void add(String fieldName, Object obj, int collectionPosition) {
        this.fields.add(new Field(fieldName, obj, collectionPosition));
    }

    public String getObjectType() {
        return this.type;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public Object getActualObject() {
        return this.actualObject;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public static enum CollectionType {
        NONE,
        MAP,
        COLLECTION;

    }

    public static class Field {
        private final String fieldName;
        private final Object value;
        private final int collectionPosition;

        public Field(String fieldName, Object value) {
            this(fieldName, value, 0);
        }

        public Field(String fieldName, Object value, int collectionPosition) {
            this.fieldName = fieldName;
            this.value = value;
            this.collectionPosition = collectionPosition;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public int getCollectionPosition() {
            return this.collectionPosition;
        }
    }
}

