/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.genericobject;

import com.netflix.zeno.diff.DiffPropertyPath;
import com.netflix.zeno.diff.DiffRecord;
import com.netflix.zeno.diff.DiffRecordValueListMap;
import com.netflix.zeno.genericobject.GenericObject;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class JaccardMatrixPairwiseMatcher {
    private final List<GenericObject.Field> objects1;
    private final List<GenericObject.Field> objects2;
    private final float[][] matrix;
    private int rowSize = 0;
    private int columnSize = 0;
    private final BitSet illegalColumns;
    private final BitSet illegalRows;
    private GenericObject.Field x;
    private GenericObject.Field y;

    public JaccardMatrixPairwiseMatcher(List<GenericObject.Field> objects1, List<DiffRecord> recs1, List<GenericObject.Field> objects2, List<DiffRecord> recs2) {
        this.objects1 = objects1;
        this.objects2 = objects2;
        this.columnSize = objects1.size();
        this.rowSize = objects2.size();
        this.matrix = new float[recs1.size()][recs2.size()];
        for (int i = 0; i < this.columnSize; ++i) {
            for (int j = 0; j < this.rowSize; ++j) {
                this.matrix[i][j] = this.calculateJaccardDistance(recs1.get(i), recs2.get(j));
            }
        }
        this.illegalColumns = new BitSet(this.columnSize);
        this.illegalRows = new BitSet();
    }

    private float calculateJaccardDistance(DiffRecord rec1, DiffRecord rec2) {
        List<Object> list2;
        List<Object> list1;
        DiffRecordValueListMap map1 = rec1.getValueListMap();
        DiffRecordValueListMap map2 = rec2.getValueListMap();
        int xorCardinality = 0;
        int unionCardinality = 0;
        for (DiffPropertyPath key : map1.keySet()) {
            list1 = map1.getList(key);
            list2 = map2.getList(key);
            if (list2 == null) {
                xorCardinality += list1.size();
                continue;
            }
            list2 = new ArrayList<Object>(list2);
            for (Object o1 : list1) {
                if (list2.contains(o1)) {
                    list2.remove(o1);
                    ++unionCardinality;
                    continue;
                }
                ++xorCardinality;
            }
        }
        for (DiffPropertyPath key : map2.keySet()) {
            list1 = map1.getList(key);
            if (list1 != null) continue;
            list2 = map2.getList(key);
            xorCardinality += list2.size();
        }
        if (xorCardinality == 0 && unionCardinality == 0) {
            return 0.0f;
        }
        return (float)xorCardinality / (float)(xorCardinality + unionCardinality);
    }

    public boolean nextPair() {
        int i;
        int minColumn = -1;
        int minRow = -1;
        float minDistance = 1.0f;
        for (i = 0; i < this.columnSize; ++i) {
            if (this.illegalColumns.get(i)) continue;
            for (int j = 0; j < this.rowSize; ++j) {
                if (this.illegalRows.get(j) || !(this.matrix[i][j] < minDistance)) continue;
                minColumn = i;
                minRow = j;
                minDistance = this.matrix[i][j];
            }
        }
        if (minDistance != 1.0f) {
            this.illegalColumns.set(minColumn);
            this.illegalRows.set(minRow);
            this.x = this.objects1.get(minColumn);
            this.y = this.objects2.get(minRow);
            return true;
        }
        for (i = 0; i < this.columnSize; ++i) {
            if (this.illegalColumns.get(i)) continue;
            this.illegalColumns.set(i);
            this.x = this.objects1.get(i);
            this.y = null;
            return true;
        }
        for (int j = 0; j < this.rowSize; ++j) {
            if (this.illegalRows.get(j)) continue;
            this.illegalRows.set(j);
            this.x = null;
            this.y = this.objects2.get(j);
            return true;
        }
        this.x = null;
        this.y = null;
        return false;
    }

    public GenericObject.Field getX() {
        return this.x;
    }

    public GenericObject.Field getY() {
        return this.y;
    }
}

