/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.hash;

import com.netflix.zeno.hash.HashGenericRecord;
import com.netflix.zeno.hash.HashOrderDependent;
import com.netflix.zeno.hash.HashOrderIndependent;
import com.netflix.zeno.serializer.FrameworkSerializer;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class HashFrameworkSerializer
extends FrameworkSerializer<HashGenericRecord> {
    HashFrameworkSerializer(SerializationFramework framework) {
        super(framework);
    }

    @Override
    public void serializePrimitive(HashGenericRecord rec, String fieldName, Object value) {
        if (value == null) {
            return;
        }
        HashGenericRecord record = rec;
        record.put(fieldName, value);
    }

    @Override
    public void serializeBytes(HashGenericRecord rec, String fieldName, byte[] value) {
        this.serializePrimitive(rec, fieldName, (Object)value);
    }

    @Override
    public void serializeObject(HashGenericRecord rec, String fieldName, String typeName, Object obj) {
        if (obj == null) {
            return;
        }
        this.getSerializer(typeName).serialize(obj, rec);
    }

    @Override
    public void serializeObject(HashGenericRecord rec, String fieldName, Object obj) {
        this.serializeObject(rec, fieldName, rec.getSchema().getObjectType(fieldName), obj);
    }

    @Override
    public <T> void serializeList(HashGenericRecord rec, String fieldName, String typeName, Collection<T> list) {
        if (list == null) {
            return;
        }
        rec.put(null, (Object)"[");
        for (T t : list) {
            this.serializeObject(rec, fieldName, typeName, t);
        }
        rec.put(null, (Object)"]");
    }

    @Override
    public <T> void serializeSet(HashGenericRecord rec, String fieldName, String typeName, Set<T> set) {
        if (set == null) {
            return;
        }
        rec.put(null, (Object)"<");
        NFTypeSerializer<T> elementSerializer = this.framework.getSerializer(typeName);
        HashGenericRecord independent = new HashGenericRecord(new HashOrderIndependent());
        for (T t : set) {
            HashGenericRecord dependent = new HashGenericRecord(new HashOrderDependent());
            elementSerializer.serialize(t, dependent);
            independent.put(null, (Object)dependent.hash());
        }
        rec.put(null, (Object)independent.hash());
        rec.put(null, (Object)">");
    }

    @Override
    public <K, V> void serializeMap(HashGenericRecord rec, String fieldName, String keyTypeName, String valueTypeName, Map<K, V> map) {
        if (map == null) {
            return;
        }
        rec.put(null, (Object)"{");
        NFTypeSerializer<K> keySerializer = this.framework.getSerializer(keyTypeName);
        NFTypeSerializer<V> valueSerializer = this.framework.getSerializer(valueTypeName);
        HashGenericRecord independent = new HashGenericRecord(new HashOrderIndependent());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashGenericRecord dependent = new HashGenericRecord(new HashOrderDependent());
            keySerializer.serialize(entry.getKey(), dependent);
            valueSerializer.serialize(entry.getValue(), dependent);
            independent.put(null, (Object)dependent.hash());
        }
        rec.put(null, (Object)independent.hash());
        rec.put(null, (Object)"}");
    }
}

