/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.hash;

import com.netflix.zeno.hash.HashAlgorithm;
import com.netflix.zeno.hash.HashGenericRecordSerializers;
import com.netflix.zeno.hash.HashOrderDependent;
import com.netflix.zeno.serializer.NFSerializationRecord;

public final class HashGenericRecord
extends NFSerializationRecord {
    HashAlgorithm hasher;

    public HashGenericRecord() {
        this(new HashOrderDependent());
    }

    public HashGenericRecord(HashAlgorithm hasher) {
        this.hasher = hasher;
    }

    public Object get(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void put(int arg0, Object arg1) {
        this.write(arg0);
        this.write(arg1);
    }

    public void put(String arg0, Object arg1) {
        this.write(arg0);
        this.write(":");
        this.write(arg1);
    }

    private void write(Object obj) {
        try {
            if (obj == null) {
                this.hasher.write(0L);
                return;
            }
            if (obj.getClass().isEnum()) {
                this.hasher.write(((Enum)obj).name());
            } else if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    HashGenericRecordSerializers.Serializer serializer = HashGenericRecordSerializers.getPrimitiveArraySerializer(obj.getClass().getComponentType());
                    if (serializer == null) {
                        throw new RuntimeException("Can't find serializer for array of type:" + obj.getClass());
                    }
                    serializer.serialize(this.hasher, obj);
                } else {
                    Object[] objects;
                    for (Object object : objects = (Object[])obj) {
                        this.write(object);
                    }
                }
            } else {
                HashGenericRecordSerializers.Serializer serializer = HashGenericRecordSerializers.getTypeSerializer(obj.getClass());
                if (serializer == null) {
                    throw new RuntimeException("Can't find serializer for type:" + obj.getClass());
                }
                serializer.serialize(this.hasher, obj);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] hash() {
        return this.hasher.bytes();
    }
}

