/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.hash;

import com.netflix.zeno.hash.HashAlgorithm;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class HashGenericRecordSerializers {
    static Map<Class<?>, Serializer> serializers = new HashMap();
    static Map<Class<?>, Serializer> primitiveArraySerializers = new HashMap();

    HashGenericRecordSerializers() {
    }

    public static Serializer getTypeSerializer(Class<?> type) {
        return serializers.get(type);
    }

    public static Serializer getPrimitiveArraySerializer(Class<?> type) {
        return primitiveArraySerializers.get(type);
    }

    static {
        Serializer stringSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((String)obj);
            }
        };
        serializers.put(String.class, stringSerializer);
        Serializer doubleSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((Double)obj);
            }
        };
        serializers.put(Double.class, doubleSerializer);
        serializers.put(Double.TYPE, doubleSerializer);
        Serializer floatSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write(((Float)obj).floatValue());
            }
        };
        serializers.put(Float.class, floatSerializer);
        serializers.put(Float.TYPE, floatSerializer);
        Serializer longSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((Long)obj);
            }
        };
        serializers.put(Long.class, longSerializer);
        serializers.put(Long.TYPE, longSerializer);
        Serializer integerSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write(((Integer)obj).intValue());
            }
        };
        serializers.put(Integer.class, integerSerializer);
        serializers.put(Integer.TYPE, integerSerializer);
        Serializer shortSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write(((Short)obj).shortValue());
            }
        };
        serializers.put(Short.class, shortSerializer);
        serializers.put(Short.TYPE, shortSerializer);
        Serializer byteSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write(((Byte)obj).byteValue());
            }
        };
        serializers.put(Byte.class, byteSerializer);
        serializers.put(Byte.TYPE, byteSerializer);
        Serializer booleanSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((Boolean)obj);
            }
        };
        serializers.put(Boolean.class, booleanSerializer);
        serializers.put(Boolean.TYPE, booleanSerializer);
        Serializer characterSerializer = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write(((Character)obj).charValue());
            }
        };
        serializers.put(Character.class, characterSerializer);
        serializers.put(Character.TYPE, characterSerializer);
        Serializer doubleSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((double[])obj);
            }
        };
        primitiveArraySerializers.put(Double.TYPE, doubleSerializer2);
        Serializer floatSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((float[])obj);
            }
        };
        primitiveArraySerializers.put(Float.TYPE, floatSerializer2);
        Serializer longSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((long[])obj);
            }
        };
        primitiveArraySerializers.put(Long.TYPE, longSerializer2);
        Serializer integerSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((int[])obj);
            }
        };
        primitiveArraySerializers.put(Integer.TYPE, integerSerializer2);
        Serializer shortSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((short[])obj);
            }
        };
        primitiveArraySerializers.put(Short.TYPE, shortSerializer2);
        Serializer byteSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((byte[])obj);
            }
        };
        primitiveArraySerializers.put(Byte.TYPE, byteSerializer2);
        Serializer booleanSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((boolean[])obj);
            }
        };
        primitiveArraySerializers.put(Boolean.TYPE, booleanSerializer2);
        Serializer characterSerializer2 = new Serializer(){

            @Override
            public void serialize(HashAlgorithm hasher, Object obj) throws IOException {
                hasher.write((char[])obj);
            }
        };
        primitiveArraySerializers.put(Character.TYPE, characterSerializer2);
    }

    public static interface Serializer {
        public void serialize(HashAlgorithm var1, Object var2) throws IOException;
    }
}

