/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zeno.hash;

import com.netflix.zeno.hash.HashAlgorithm;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.apache.commons.io.output.NullOutputStream;

public class HashOrderDependent
implements HashAlgorithm {
    MessageDigest digest;
    DigestOutputStream digestOutputStream;
    DataOutputStream dataOutputStream;

    public HashOrderDependent() {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.digestOutputStream = new DigestOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, this.digest);
        this.dataOutputStream = new DataOutputStream(this.digestOutputStream);
    }

    @Override
    public void write(char b) throws IOException {
        this.dataOutputStream.write(b);
    }

    @Override
    public void write(boolean b) throws IOException {
        this.dataOutputStream.writeBoolean(b);
    }

    @Override
    public void write(long b) throws IOException {
        this.dataOutputStream.writeLong(b);
    }

    @Override
    public void write(float b) throws IOException {
        this.dataOutputStream.writeFloat(b);
    }

    @Override
    public void write(double b) throws IOException {
        this.dataOutputStream.writeDouble(b);
    }

    @Override
    public void write(String b) throws IOException {
        this.dataOutputStream.writeUTF(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataOutputStream.write(b);
    }

    @Override
    public void write(char[] b) throws IOException {
        for (char c : b) {
            this.dataOutputStream.writeChar(c);
        }
    }

    @Override
    public void write(boolean[] b) throws IOException {
        for (boolean c : b) {
            this.dataOutputStream.writeBoolean(c);
        }
    }

    @Override
    public void write(short[] b) throws IOException {
        for (short c : b) {
            this.dataOutputStream.writeShort(c);
        }
    }

    @Override
    public void write(int[] b) throws IOException {
        for (int c : b) {
            this.dataOutputStream.writeInt(c);
        }
    }

    @Override
    public void write(long[] b) throws IOException {
        for (long c : b) {
            this.dataOutputStream.writeLong(c);
        }
    }

    @Override
    public void write(float[] b) throws IOException {
        for (float c : b) {
            this.dataOutputStream.writeFloat(c);
        }
    }

    @Override
    public void write(double[] b) throws IOException {
        for (double c : b) {
            this.dataOutputStream.writeDouble(c);
        }
    }

    @Override
    public byte[] bytes() {
        try {
            this.digestOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.digest.digest();
    }
}

